@extends('layouts.app')

@section('content')
<!-- Animated Particle Background -->
<div class="particle-container">
    <div class="particle particle-1"></div>
    <div class="particle particle-2"></div>
    <div class="particle particle-3"></div>
    <div class="particle particle-4"></div>
    <div class="particle particle-5"></div>
</div>

<!-- Morphing Blob Background -->
<div class="blob-container">
    <div class="blob blob-1"></div>
    <div class="blob blob-2"></div>
    <div class="blob blob-3"></div>
</div>

<div class="container-fluid py-4 bg-gradient position-relative">
    <!-- Enhanced Page Header with Gradient Background -->
    <div class="page-header-wrapper mb-5">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <div class="d-flex align-items-center">
                    <div class="icon-wrapper me-3">
                        <div class="icon-box gradient-primary">
                            <i class="fas fa-hand-holding-usd fs-3"></i>
                        </div>
                    </div>
                    <div>
                        <h1 class="page-title mb-1">
                            <span class="title-letter" style="--i: 0">L</span>
                            <span class="title-letter" style="--i: 1">o</span>
                            <span class="title-letter" style="--i: 2">a</span>
                            <span class="title-letter" style="--i: 3">n</span>
                            <span class="title-letter" style="--i: 4"> </span>
                            <span class="title-letter" style="--i: 5">A</span>
                            <span class="title-letter" style="--i: 6">p</span>
                            <span class="title-letter" style="--i: 7">p</span>
                            <span class="title-letter" style="--i: 8">l</span>
                            <span class="title-letter" style="--i: 9">i</span>
                            <span class="title-letter" style="--i: 10">c</span>
                            <span class="title-letter" style="--i: 11">a</span>
                            <span class="title-letter" style="--i: 12">t</span>
                            <span class="title-letter" style="--i: 13">i</span>
                            <span class="title-letter" style="--i: 14">o</span>
                            <span class="title-letter" style="--i: 15">n</span>
                            <span class="title-letter" style="--i: 16">s</span>
                            <span class="title-letter" style="--i: 17"> </span>
                            <span class="title-letter" style="--i: 18">D</span>
                            <span class="title-letter" style="--i: 19">a</span>
                            <span class="title-letter" style="--i: 20">s</span>
                            <span class="title-letter" style="--i: 21">h</span>
                            <span class="title-letter" style="--i: 22">b</span>
                            <span class="title-letter" style="--i: 23">o</span>
                            <span class="title-letter" style="--i: 24">a</span>
                            <span class="title-letter" style="--i: 25">r</span>
                            <span class="title-letter" style="--i: 26">d</span>
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                                <li class="breadcrumb-item active">ESS Loans</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 text-lg-end mt-3 mt-lg-0">
                <div class="action-buttons">
                    <button class="btn btn-gradient-primary btn-lg shadow-sm magnetic-btn" onclick="refreshFromESS()">
                        <i class="fas fa-sync-alt me-2"></i>Sync ESS
                    </button>
                    <div class="btn-group ms-2">
                        <button class="btn btn-light btn-lg shadow-sm" data-bs-toggle="dropdown">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="#" onclick="exportReport('excel')">
                                <i class="fas fa-file-excel me-2 text-success"></i>Export Excel</a></li>
                            <li><a class="dropdown-item" href="#" onclick="exportReport('pdf')">
                                <i class="fas fa-file-pdf me-2 text-danger"></i>Export PDF</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="#" onclick="showBulkActions()">
                                <i class="fas fa-tasks me-2"></i>Bulk Actions</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modern Stats Dashboard -->
    <div class="row g-4 mb-5">
        <!-- Total Applications Card -->
        <div class="col-xl-3 col-lg-6">
            <div class="stat-card card h-100 border-0 shadow-hover glass-effect">
                <div class="card-body position-relative overflow-hidden">
                    <div class="floating-icon">
                        <i class="fas fa-hourglass-half opacity-10"></i>
                    </div>
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon bg-gradient-warning pulse-animation">
                                <i class="fas fa-hourglass-half"></i>
                            </div>
                        </div>
                        <span class="badge badge-pill bg-warning-subtle text-warning shimmer">Pending</span>
                    </div>
                    <h2 class="stat-number mb-1 counter-animation" data-value="{{ $pendingCount ?? 0 }}">0</h2>
                    <p class="stat-label mb-2 text-muted">Awaiting Approval</p>
                    <div class="progress progress-sm mb-2" style="height: 6px;">
                        <div class="progress-bar bg-gradient-warning progress-animated" style="width: {{ min(($pendingCount ?? 0) * 10, 100) }}%"></div>
                    </div>
                    <small class="text-muted"><i class="fas fa-clock me-1"></i>Requires action</small>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-lg-6">
            <div class="stat-card card h-100 border-0 shadow-hover glass-effect">
                <div class="card-body position-relative overflow-hidden">
                    <div class="floating-icon">
                        <i class="fas fa-check-double opacity-10"></i>
                    </div>
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon bg-gradient-success pulse-animation">
                                <i class="fas fa-check-double"></i>
                            </div>
                        </div>
                        <span class="badge badge-pill bg-success-subtle text-success shimmer">Approved</span>
                    </div>
                    <h2 class="stat-number mb-1 counter-animation" data-value="{{ $approvedCount ?? 0 }}">0</h2>
                    <p class="stat-label mb-2 text-muted">Ready for Disbursement</p>
                    <div class="progress progress-sm mb-2" style="height: 6px;">
                        <div class="progress-bar bg-gradient-success progress-animated" style="width: {{ min(($approvedCount ?? 0) * 10, 100) }}%"></div>
                    </div>
                    <small class="text-success"><i class="fas fa-trending-up me-1"></i>Ready to process</small>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-lg-6">
            <div class="stat-card card h-100 border-0 shadow-hover glass-effect">
                <div class="card-body position-relative overflow-hidden">
                    <div class="floating-icon">
                        <i class="fas fa-university opacity-10"></i>
                    </div>
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon bg-gradient-info pulse-animation">
                                <i class="fas fa-university"></i>
                            </div>
                        </div>
                        <span class="badge bg-info-subtle text-info">Processing</span>
                    </div>
                    <h2 class="stat-number mb-1" data-value="{{ $pendingNMBCount ?? 0 }}">{{ $pendingNMBCount ?? 0 }}</h2>
                    <p class="stat-label mb-2">NMB Processing</p>
                    <div class="progress progress-sm">
                        <div class="progress-bar bg-info progress-bar-animated progress-bar-striped" style="width: {{ ($pendingNMBCount ?? 0) * 10 }}%"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-lg-6">
            <div class="stat-card card h-100 border-0 shadow-hover">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon bg-gradient-primary">
                                <i class="fas fa-coins"></i>
                            </div>
                        </div>
                        <span class="badge bg-primary-subtle text-primary">Today</span>
                    </div>
                    <h2 class="stat-number mb-1">{{ number_format($totalDisbursed ?? 0, 0) }}</h2>
                    <p class="stat-label mb-2">TZS Disbursed</p>
                    @if(($totalDisbursed ?? 0) > 0)
                        <small class="text-success">
                            <i class="fas fa-arrow-up me-1"></i>Active Today
                        </small>
                    @else
                        <small class="text-muted">
                            No disbursements today
                        </small>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Filters Section -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-0 py-3">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-filter me-2 text-primary"></i>Filter Applications</h5>
                <button class="btn btn-sm btn-link text-decoration-none" onclick="clearFilters()">
                    <i class="fas fa-times me-1"></i>Clear All
                </button>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('loan-offers.index') }}" id="filter-form">
                <div class="row g-3">
                    <div class="col-lg-4">
                        <div class="search-box">
                            <input type="text" name="search" class="form-control form-control-lg border-0 bg-light" 
                                   placeholder="Search by name, application #, check #..." 
                                   value="{{ request('search') }}">
                            <div class="search-icon">
                                <i class="fas fa-search"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-2 col-md-6">
                        <select name="status" class="form-select form-select-lg border-0 bg-light">
                            <option value="">All Status</option>
                            <option value="pending_approval" {{ request('status') == 'pending_approval' ? 'selected' : '' }}>
                                <i class="fas fa-clock"></i> Pending
                            </option>
                            <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>
                                <i class="fas fa-check"></i> Approved
                            </option>
                            <option value="disbursement_pending" {{ request('status') == 'disbursement_pending' ? 'selected' : '' }}>
                                <i class="fas fa-spinner"></i> Processing
                            </option>
                            <option value="disbursed" {{ request('status') == 'disbursed' ? 'selected' : '' }}>
                                <i class="fas fa-check-double"></i> Disbursed
                            </option>
                            <option value="DISBURSEMENT_FAILED" {{ request('status') == 'DISBURSEMENT_FAILED' ? 'selected' : '' }}>
                                <i class="fas fa-times"></i> Failed
                            </option>
                            <option value="FULL_SETTLED" {{ request('status') == 'FULL_SETTLED' ? 'selected' : '' }}>
                                <i class="fas fa-handshake"></i> Settled
                            </option>
                        </select>
                    </div>
                    
                    <div class="col-lg-2 col-md-6">
                        <input type="date" name="date_from" class="form-control form-control-lg border-0 bg-light" 
                               value="{{ request('date_from') }}" placeholder="From Date">
                    </div>
                    
                    <div class="col-lg-2 col-md-6">
                        <input type="date" name="date_to" class="form-control form-control-lg border-0 bg-light" 
                               value="{{ request('date_to') }}" placeholder="To Date">
                    </div>
                    
                    <div class="col-lg-2 col-md-6">
                        <button type="submit" class="btn btn-gradient-primary btn-lg w-100">
                            <i class="fas fa-search me-2"></i>Apply Filters
                        </button>
                    </div>
                </div>
                
                <!-- Quick Filters -->
                <div class="quick-filters mt-3">
                    <span class="me-2 text-muted">Quick filters:</span>
                    <button type="button" class="btn btn-sm btn-outline-primary me-2" onclick="setQuickFilter('today')">
                        Today
                    </button>
                    <button type="button" class="btn btn-sm btn-outline-primary me-2" onclick="setQuickFilter('week')">
                        This Week
                    </button>
                    <button type="button" class="btn btn-sm btn-outline-primary me-2" onclick="setQuickFilter('month')">
                        This Month
                    </button>
                    <button type="button" class="btn btn-sm btn-outline-warning me-2" onclick="setQuickFilter('pending')">
                        Pending Only
                    </button>
                    <button type="button" class="btn btn-sm btn-outline-success" onclick="setQuickFilter('approved')">
                        Approved Only
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Enhanced Loan Applications Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0 py-3">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h5 class="mb-0">Loan Applications</h5>
                    <p class="text-muted mb-0 small">Showing {{ $loanOffers->count() }} of {{ $loanOffers->total() ?? 0 }} applications</p>
                </div>
                <div class="d-flex align-items-center gap-2">
                    <div class="btn-group">
                        <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="dropdown">
                            <i class="fas fa-columns me-1"></i>Columns
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><label class="dropdown-item"><input type="checkbox" checked> Employee</label></li>
                            <li><label class="dropdown-item"><input type="checkbox" checked> Application</label></li>
                            <li><label class="dropdown-item"><input type="checkbox" checked> Amount</label></li>
                            <li><label class="dropdown-item"><input type="checkbox" checked> Status</label></li>
                        </ul>
                    </div>
                    <button class="btn btn-sm btn-outline-secondary" onclick="toggleTableView()">
                        <i class="fas fa-th-large me-1"></i>Card View
                    </button>
                </div>
            </div>
        </div>
        <div class="card-body p-0" style="position: relative; z-index: 1;">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0" style="position: relative; z-index: 1;">
                    <thead style="background: linear-gradient(135deg, #17479E 0%, #1e5bb8 100%);">
                        <tr>
                            <th class="ps-4" width="40" style="color: white;">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="select-all">
                                </div>
                            </th>
                            <th class="sortable" onclick="sortTable('name')" style="color: white;">
                                Name <i class="fas fa-sort ms-1" style="opacity: 0.7; color: white;"></i>
                            </th>
                            <th class="text-end sortable" onclick="sortTable('salary')" style="color: white;">
                                Salary <i class="fas fa-sort ms-1" style="opacity: 0.7; color: white;"></i>
                            </th>
                            <th class="text-end sortable" onclick="sortTable('deductible')" style="color: white;">
                                Deduct <i class="fas fa-sort ms-1" style="opacity: 0.7; color: white;"></i>
                            </th>
                            <th class="text-end sortable" onclick="sortTable('requested')" style="color: white;">
                                Amount <i class="fas fa-sort ms-1" style="opacity: 0.7; color: white;"></i>
                            </th>
                            <th class="text-center" style="color: white;">Tenure</th>
                            <th class="text-center" style="color: white;">Approval</th>
                            <th class="text-center" style="color: white;">Status</th>
                            <th class="text-center" width="50" style="color: white;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($loanOffers as $offer)
                            <tr class="loan-row" data-id="{{ $offer->id }}">
                                <td class="ps-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input loan-checkbox" 
                                               value="{{ $offer->id }}" id="check-{{ $offer->id }}">
                                    </div>
                                </td>
                                <td>
                                    <div class="text-truncate" style="max-width: 200px;">
                                        <div class="fw-semibold text-truncate" title="{{ $offer->first_name }} {{ $offer->middle_name }} {{ $offer->last_name }}">
                                            {{ $offer->first_name }} {{ $offer->middle_name }} {{ $offer->last_name }}
                                        </div>
                                        <small class="text-muted">{{ $offer->check_number }}</small>
                                    </div>
                                </td>
                                <td class="text-end">
                                    <div class="fw-semibold">{{ number_format($offer->basic_salary ?? 0, 0) }}</div>
                                    <small class="text-muted d-block" style="font-size: 0.7rem;">{{ number_format($offer->net_salary ?? 0, 0) }}</small>
                                </td>
                                <td class="text-end">
                                    <div class="fw-semibold" style="color: #f57c00;">{{ number_format($offer->desired_deductible_amount ?? 0, 0) }}</div>
                                </td>
                                <td class="text-end">
                                    <div class="fw-bold" style="color: #17479E;">{{ number_format($offer->requested_amount ?? 0, 0) }}</div>
                                </td>
                                <td class="text-center">
                                    @if($offer->tenure)
                                        <span class="badge" style="background-color: #17479E;">{{ $offer->tenure }} mo</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @switch($offer->approval)
                                        @case('APPROVED')
                                            <span class="badge bg-success" title="Approved" data-bs-toggle="tooltip">
                                                <i class="fas fa-check"></i>
                                            </span>
                                            @break
                                        @case('REJECTED')
                                            <span class="badge bg-danger" title="Rejected" data-bs-toggle="tooltip">
                                                <i class="fas fa-times"></i>
                                            </span>
                                            @break
                                        @default
                                            <span class="badge bg-warning" title="Pending" data-bs-toggle="tooltip">
                                                <i class="fas fa-clock"></i>
                                            </span>
                                    @endswitch
                                </td>
                                <td class="text-center">
                                    @switch($offer->status)
                                        @case('disbursement_pending')
                                            <span class="badge bg-info" title="NMB Processing">Processing</span>
                                            @break
                                        @case('disbursed')
                                            <span class="badge bg-success">Disbursed</span>
                                            @break
                                        @case('DISBURSEMENT_FAILED')
                                            <span class="badge bg-danger" title="{{ $offer->reason }}">Failed</span>
                                            @break
                                        @case('FULL_SETTLED')
                                            <span class="badge bg-dark">Settled</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary">{{ $offer->status ?: 'New' }}</span>
                                    @endswitch
                                </td>
                                <td class="text-center">
                                    <div class="d-flex justify-content-center gap-1">
                                        <button type="button" 
                                                class="btn btn-sm p-1 view-loan-btn" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#loanDetailsModal"
                                                title="View Details"
                                                data-loan='{{ json_encode($offer) }}'
                                                style="width: 22px; height: 22px; font-size: 0.7rem; background-color: transparent; border: none; color: #17479E;">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <a class="btn btn-sm p-1" 
                                           href="{{ route('loan-offers.edit', $offer->id) }}"
                                           title="Edit"
                                           style="width: 22px; height: 22px; font-size: 0.7rem; background-color: transparent; border: none; color: #6c757d;">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if($offer->approval !== 'APPROVED' && $offer->status !== 'disbursed')
                                            <button class="btn btn-sm p-1" 
                                                    onclick="approveLoan({{ $offer->id }})" 
                                                    title="Approve"
                                                    style="width: 22px; height: 22px; font-size: 0.7rem; background-color: transparent; border: none; color: #28a745;">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @endif
                                        @if($offer->approval !== 'REJECTED' && $offer->status !== 'disbursed')
                                            <button class="btn btn-sm p-1" 
                                                    onclick="rejectLoan({{ $offer->id }})"
                                                    title="Reject"
                                                    style="width: 22px; height: 22px; font-size: 0.7rem; background-color: transparent; border: none; color: #dc3545;">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center py-5">
                                    <div class="empty-state">
                                        <div class="empty-icon mb-4">
                                            <i class="fas fa-folder-open fa-4x text-muted opacity-50"></i>
                                        </div>
                                        <h5 class="text-muted mb-2">No Loan Applications Found</h5>
                                        <p class="text-muted mb-4">Start by syncing data from ESS or adjusting your filters</p>
                                        <div class="d-flex justify-content-center gap-2">
                                            <button class="btn btn-gradient-primary" onclick="refreshFromESS()">
                                                <i class="fas fa-sync-alt me-2"></i>Sync from ESS
                                            </button>
                                            <button class="btn btn-outline-secondary" onclick="clearFilters()">
                                                <i class="fas fa-filter me-2"></i>Clear Filters
                                            </button>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if($loanOffers->hasPages())
                <div class="card-footer bg-white border-top">
                    <div class="row align-items-center">
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                <label class="me-2 text-muted">Show:</label>
                                <select class="form-select form-select-sm w-auto" onchange="changePageSize(this.value)">
                                    <option value="10">10</option>
                                    <option value="25" selected>25</option>
                                    <option value="50">50</option>
                                    <option value="100">100</option>
                                </select>
                                <span class="ms-2 text-muted">entries</span>
                            </div>
                        </div>
                        <div class="col-md-4 text-center">
                            <small class="text-muted">
                                Showing <strong>{{ $loanOffers->firstItem() }}</strong> to <strong>{{ $loanOffers->lastItem() }}</strong> 
                                of <strong>{{ $loanOffers->total() }}</strong> applications
                            </small>
                        </div>
                        <div class="col-md-4 d-flex justify-content-end">
                            {{ $loanOffers->appends(request()->query())->links('pagination::bootstrap-5') }}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Enhanced Loan Details Modal -->
<div class="modal fade" id="loanDetailsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content border-0 shadow-2xl modal-ura-enhanced">
            <!-- Animated Background Pattern -->
            <div class="modal-pattern"></div>
            
            <!-- Modal Header with Gradient -->
            <div class="modal-header modal-header-ura border-0 position-relative overflow-hidden">
                <div class="header-content position-relative z-index-1">
                    <div class="d-flex align-items-center">
                        <div class="modal-icon-wrapper me-3">
                            <div class="modal-icon-circle">
                                <i class="fas fa-file-invoice-dollar"></i>
                            </div>
                        </div>
                        <div>
                            <h4 class="modal-title mb-1 fw-bold text-white">Loan Application Details</h4>
                            <p class="mb-0 small text-white" style="opacity: 0.9;">Comprehensive loan information and status</p>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white position-relative z-index-1" data-bs-dismiss="modal"></button>
                <div class="header-decoration"></div>
            </div>
            <div class="modal-body p-0">
                <!-- Enhanced Tab Navigation -->
                <div class="tab-navigation-wrapper">
                    <ul class="nav nav-tabs nav-tabs-ura nav-fill border-0" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link nav-link-ura active" data-bs-toggle="tab" href="#personal-info">
                                <div class="tab-icon-box">
                                    <i class="fas fa-user-circle"></i>
                                </div>
                                <span class="tab-label">Personal</span>
                                <div class="tab-indicator"></div>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link nav-link-ura" data-bs-toggle="tab" href="#employment-info">
                                <div class="tab-icon-box">
                                    <i class="fas fa-briefcase"></i>
                                </div>
                                <span class="tab-label">Employment</span>
                                <div class="tab-indicator"></div>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link nav-link-ura" data-bs-toggle="tab" href="#loan-info">
                                <div class="tab-icon-box">
                                    <i class="fas fa-hand-holding-usd"></i>
                                </div>
                                <span class="tab-label">Loan</span>
                                <div class="tab-indicator"></div>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link nav-link-ura" data-bs-toggle="tab" href="#financial-info">
                                <div class="tab-icon-box">
                                    <i class="fas fa-chart-pie"></i>
                                </div>
                                <span class="tab-label">Financial</span>
                                <div class="tab-indicator"></div>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link nav-link-ura" data-bs-toggle="tab" href="#bank-info">
                                <div class="tab-icon-box">
                                    <i class="fas fa-university"></i>
                                </div>
                                <span class="tab-label">Banking</span>
                                <div class="tab-indicator"></div>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link nav-link-ura" data-bs-toggle="tab" href="#process-loan">
                                <div class="tab-icon-box">
                                    <i class="fas fa-cogs"></i>
                                </div>
                                <span class="tab-label">Process Loan</span>
                                <div class="tab-indicator"></div>
                            </a>
                        </li>
                    </ul>
                </div>
                
                <!-- Tab Content -->
                <div class="tab-content p-4">
                    <!-- Personal Information Tab -->
                    <div class="tab-pane fade show active" id="personal-info">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-id-card"></i>
                                        </div>
                                        <h6 class="info-card-title">Basic Information</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Full Name</small>
                                        <div class="fw-semibold" id="modal-full-name"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Check Number</small>
                                        <div class="fw-semibold" id="modal-check-number"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">NIN</small>
                                        <div class="fw-semibold" id="modal-nin"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Gender</small>
                                        <div class="fw-semibold" id="modal-sex"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Marital Status</small>
                                        <div class="fw-semibold" id="modal-marital-status"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-address-book"></i>
                                        </div>
                                        <h6 class="info-card-title">Contact Information</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Mobile Number</small>
                                        <div class="fw-semibold" id="modal-mobile"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Email Address</small>
                                        <div class="fw-semibold" id="modal-email"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Telephone</small>
                                        <div class="fw-semibold" id="modal-telephone"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Physical Address</small>
                                        <div class="fw-semibold" id="modal-address"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Employment Information Tab -->
                    <div class="tab-pane fade" id="employment-info">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-building"></i>
                                        </div>
                                        <h6 class="info-card-title">Employment Details</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Designation</small>
                                        <div class="fw-semibold" id="modal-designation"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Vote Name</small>
                                        <div class="fw-semibold" id="modal-vote-name"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Vote Code</small>
                                        <div class="fw-semibold" id="modal-vote-code"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Terms of Employment</small>
                                        <div class="fw-semibold" id="modal-terms"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-calendar-alt"></i>
                                        </div>
                                        <h6 class="info-card-title">Employment Dates</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Employment Date</small>
                                        <div class="fw-semibold" id="modal-employment-date"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Confirmation Date</small>
                                        <div class="fw-semibold" id="modal-confirmation-date"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Retirement Date</small>
                                        <div class="fw-semibold" id="modal-retirement-date"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Loan Details Tab -->
                    <div class="tab-pane fade" id="loan-info">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-file-invoice"></i>
                                        </div>
                                        <h6 class="info-card-title">Loan Information</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Application Number</small>
                                        <div class="fw-semibold text-primary" id="modal-app-number"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Loan Purpose</small>
                                        <div class="fw-semibold" id="modal-loan-purpose"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">FSP Reference</small>
                                        <div class="fw-semibold" id="modal-fsp-ref"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Loan Number</small>
                                        <div class="fw-semibold" id="modal-loan-number"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-percentage"></i>
                                        </div>
                                        <h6 class="info-card-title">Loan Terms</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Tenure</small>
                                        <div class="fw-semibold" id="modal-tenure"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Interest Rate</small>
                                        <div class="fw-semibold" id="modal-interest-rate"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Processing Fee</small>
                                        <div class="fw-semibold" id="modal-processing-fee"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Insurance</small>
                                        <div class="fw-semibold" id="modal-insurance"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Financial Information Tab -->
                    <div class="tab-pane fade" id="financial-info">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-money-bill-wave"></i>
                                        </div>
                                        <h6 class="info-card-title">Salary Information</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Basic Salary</small>
                                        <div class="fw-semibold text-success" id="modal-basic-salary"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Net Salary</small>
                                        <div class="fw-semibold text-success" id="modal-net-salary"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">One Third Amount</small>
                                        <div class="fw-semibold" id="modal-one-third"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Total Deductions</small>
                                        <div class="fw-semibold text-danger" id="modal-deductions"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-coins"></i>
                                        </div>
                                        <h6 class="info-card-title">Loan Amounts</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Requested Amount</small>
                                        <div class="fw-semibold text-primary fs-5" id="modal-requested-amount"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Total Amount to Pay</small>
                                        <div class="fw-semibold text-danger fs-5" id="modal-total-amount"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Monthly Deduction</small>
                                        <div class="fw-semibold text-warning" id="modal-monthly-deduction"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Other Charges</small>
                                        <div class="fw-semibold" id="modal-other-charges"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Banking Information Tab -->
                    <div class="tab-pane fade" id="bank-info">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-credit-card"></i>
                                        </div>
                                        <h6 class="info-card-title">Bank Account</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Account Number</small>
                                        <div class="fw-semibold" id="modal-account-number"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Swift Code</small>
                                        <div class="fw-semibold" id="modal-swift-code"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Branch Name</small>
                                        <div class="fw-semibold" id="modal-branch-name"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Branch Code</small>
                                        <div class="fw-semibold" id="modal-branch-code"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-info-circle"></i>
                                        </div>
                                        <h6 class="info-card-title">Status Information</h6>
                                    </div>
                                    <div class="info-card-body">
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Approval Status</small>
                                        <div class="fw-semibold" id="modal-approval-status"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Processing Status</small>
                                        <div class="fw-semibold" id="modal-processing-status"></div>
                                    </div>
                                    <div class="info-item mb-2">
                                        <small class="text-muted">Created Date</small>
                                        <div class="fw-semibold" id="modal-created-date"></div>
                                    </div>
                                    <div class="info-item">
                                        <small class="text-muted">Last Updated</small>
                                        <div class="fw-semibold" id="modal-updated-date"></div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Process Loan Tab -->
                    <div class="tab-pane fade" id="process-loan">
                        <div class="row g-4">
                            <div class="col-12">
                                <div class="info-card-enhanced">
                                    <div class="info-card-header">
                                        <div class="info-card-icon">
                                            <i class="fas fa-clipboard-check"></i>
                                        </div>
                                        <h6 class="info-card-title">Loan Processing Actions</h6>
                                    </div>
                                    <div class="info-card-body p-4">
                                        <!-- Current Status Display -->
                                        <div class="alert alert-info mb-4">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-info-circle me-2"></i>
                                                <div>
                                                    <strong>Current Status:</strong>
                                                    <span id="process-current-approval" class="ms-2"></span>
                                                    <span id="process-current-status" class="ms-2"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Processing Actions -->
                                        <div class="processing-actions">
                                            <h6 class="mb-3">Select Action:</h6>
                                            <div class="row g-3">
                                                <!-- Approve Action -->
                                                <div class="col-md-6">
                                                    <div class="action-card p-3 border rounded hover-shadow" role="button" onclick="selectProcessAction('approve')">
                                                        <div class="d-flex align-items-center">
                                                            <div class="action-icon text-success me-3">
                                                                <i class="fas fa-check-circle fa-2x"></i>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-1">Approve Loan</h6>
                                                                <small class="text-muted">Approve this loan application</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Reject Action -->
                                                <div class="col-md-6">
                                                    <div class="action-card p-3 border rounded hover-shadow" role="button" onclick="selectProcessAction('reject')">
                                                        <div class="d-flex align-items-center">
                                                            <div class="action-icon text-danger me-3">
                                                                <i class="fas fa-times-circle fa-2x"></i>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-1">Reject Loan</h6>
                                                                <small class="text-muted">Reject this loan application</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Draft/Archive Action -->
                                                <div class="col-md-6">
                                                    <div class="action-card p-3 border rounded hover-shadow" role="button" onclick="selectProcessAction('draft')">
                                                        <div class="d-flex align-items-center">
                                                            <div class="action-icon text-warning me-3">
                                                                <i class="fas fa-archive fa-2x"></i>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-1">Save as Draft</h6>
                                                                <small class="text-muted">Save for later review</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Action Form (Hidden by default) -->
                                            <div id="process-action-form" class="mt-4" style="display: none;">
                                                <hr>
                                                <form id="loan-process-form">
                                                    <input type="hidden" id="process-loan-id" name="loan_id">
                                                    <input type="hidden" id="process-action-type" name="action">
                                                    
                                                    <!-- Reason/Comments Field -->
                                                    <div class="mb-3" id="process-reason-field" style="display: none;">
                                                        <label class="form-label">Reason/Comments <span class="text-danger">*</span></label>
                                                        <textarea class="form-control" id="process-reason" name="reason" rows="3" placeholder="Enter reason or comments..."></textarea>
                                                    </div>

                                                    <!-- Action Buttons -->
                                                    <div class="d-flex justify-content-end gap-2">
                                                        <button type="button" class="btn btn-secondary" onclick="cancelProcessAction()">Cancel</button>
                                                        <button type="submit" class="btn btn-primary" id="process-submit-btn">
                                                            <span class="spinner-border spinner-border-sm me-2" style="display: none;"></span>
                                                            Submit
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer border-0 bg-light">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Actions Modal -->
<div class="modal fade" id="bulkActionsModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Bulk Actions</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Select an action for <span id="selected-count">0</span> selected loans:</p>
                <div class="d-grid gap-2">
                    <button class="btn btn-ura-success" onclick="bulkDisburse()">
                        <i class="fas fa-paper-plane me-2"></i>Disburse Selected
                    </button>
                    <button class="btn btn-outline-danger" onclick="bulkReject()">
                        <i class="fas fa-times me-2"></i>Reject Selected
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Floating Action Button -->
<div class="fab" onclick="showQuickActions()">
    <i class="fas fa-plus"></i>
</div>

<!-- Quick Actions Menu -->
<div id="quick-actions" class="quick-actions-menu">
    <button class="quick-action-btn" onclick="refreshFromESS()" data-tooltip="Sync with ESS">
        <i class="fas fa-sync-alt"></i>
    </button>
    <button class="quick-action-btn" onclick="exportReport('excel')" data-tooltip="Export Excel">
        <i class="fas fa-file-excel"></i>
    </button>
    <button class="quick-action-btn" onclick="exportReport('pdf')" data-tooltip="Export PDF">
        <i class="fas fa-file-pdf"></i>
    </button>
    <button class="quick-action-btn" onclick="showFilters()" data-tooltip="Filter">
        <i class="fas fa-filter"></i>
    </button>
</div>

<!-- Toast Notification Container -->
<div id="toast-container" class="toast-container position-fixed top-0 end-0 p-3"></div>

<!-- Loading Overlay -->
<div id="loading-overlay" class="loading-overlay">
    <div class="loading-spinner">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
        <p class="mt-3 text-muted">Processing your request...</p>
    </div>
</div>
@endsection

@push('styles')
<style>
/* Modern Color Palette */
:root {
    --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --success-gradient: linear-gradient(135deg, #23d5ab 0%, #23a455 100%);
    --warning-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    --info-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    --danger-gradient: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
}

/* Page Background */
.bg-gradient {
    background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%);
    min-height: 100vh;
}

/* Page Header */
.page-header-wrapper {
    background: white;
    border-radius: 16px;
    padding: 2rem;
    box-shadow: 0 2px 20px rgba(0, 0, 0, 0.04);
}

.page-title {
    font-size: 1.875rem;
    font-weight: 800;
    background: linear-gradient(135deg, #17479E 0%, #2563c7 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    letter-spacing: 0.5px;
    text-transform: uppercase;
}

.icon-box {
    width: 60px;
    height: 60px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.gradient-primary {
    background: var(--primary-gradient);
}

.gradient-success {
    background: var(--success-gradient);
}

/* Stat Cards */
.stat-card {
    background: rgba(255, 255, 255, 0.98);
    backdrop-filter: blur(20px);
    border-radius: 24px;
    border: 2px solid rgba(23, 71, 158, 0.08);
    transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    position: relative;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(23, 71, 158, 0.08);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    right: -100%;
    height: 4px;
    background: linear-gradient(90deg, 
        transparent,
        #17479E 40%,
        #2563c7 50%,
        #17479E 60%,
        transparent);
    animation: slideAcross 3s ease-in-out infinite;
    opacity: 0;
    transition: opacity 0.3s ease;
}

@keyframes slideAcross {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(200%); }
}

.stat-card::after {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle at center, 
        rgba(23, 71, 158, 0.03) 0%, 
        transparent 70%);
    animation: rotateGradient 20s linear infinite;
}

@keyframes rotateGradient {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.stat-card:hover::before {
    opacity: 1;
}

.stat-card:hover {
    border-color: rgba(23, 71, 158, 0.2);
}

.shadow-hover:hover {
    transform: translateY(-12px) scale(1.02) rotate(0.5deg);
    box-shadow: 0 20px 50px rgba(23, 71, 158, 0.25);
}

.stat-icon-wrapper {
    position: relative;
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    color: white;
}

.bg-gradient-warning {
    background: var(--warning-gradient);
}

.bg-gradient-success {
    background: var(--success-gradient);
}

.bg-gradient-info {
    background: var(--info-gradient);
}

.bg-gradient-primary {
    background: var(--primary-gradient);
}

.stat-number {
    font-size: 2rem;
    font-weight: 700;
    color: #1a1d23;
    line-height: 1;
}

.stat-label {
    color: #6c757d;
    font-size: 0.875rem;
}

.progress-sm {
    height: 4px;
    border-radius: 2px;
    background: #f0f2f5;
}

/* Enhanced Search Box */
.search-box {
    position: relative;
}

.search-box input {
    padding-left: 3rem;
    border-radius: 12px;
    font-size: 1rem;
}

.search-icon {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #6c757d;
}

/* Quick Filters */
.quick-filters button {
    border-radius: 20px;
    padding: 0.25rem 1rem;
    font-size: 0.875rem;
    transition: all 0.2s ease;
}

.quick-filters button:hover {
    transform: translateY(-2px);
}

/* Enhanced Button Styles */
.btn-gradient-primary {
    background: var(--primary-gradient);
    color: white;
    border: none;
    border-radius: 12px;
    padding: 0.5rem 1.5rem;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-gradient-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
    color: white;
}

/* Table Enhancements */
.table-hover tbody tr {
    transition: all 0.2s ease;
    cursor: pointer;
    border-left: 3px solid transparent;
}

.table-hover tbody tr:hover {
    background-color: rgba(23, 71, 158, 0.05);
    border-left: 3px solid #17479E;
    transform: translateX(2px);
}

/* Row selection styling */
.table-hover tbody tr.table-active {
    background-color: rgba(23, 71, 158, 0.1);
    border-left: 3px solid #17479E;
}

.sortable {
    cursor: pointer;
    user-select: none;
}

.sortable:hover {
    background-color: rgba(0, 0, 0, 0.02);
}

/* Avatar Styles */
.avatar-wrapper {
    position: relative;
}

.avatar-circle {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    position: relative;
}

.avatar-circle.avatar-sm {
    width: 28px;
    height: 28px;
}

.avatar-circle.avatar-sm .avatar-text {
    font-size: 0.7rem;
}

.avatar-text {
    color: white;
    font-weight: 600;
    font-size: 0.9rem;
}

.avatar-badge {
    position: absolute;
    bottom: 0;
    right: 0;
    width: 14px;
    height: 14px;
    border-radius: 50%;
    border: 2px solid white;
}

/* Badge Enhancements */
.badge {
    font-weight: 500;
    padding: 0.4rem 0.8rem;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
}

.badge.rounded-pill {
    border-radius: 20px;
}

/* Status Indicators */
.spinner-border-sm {
    width: 1rem;
    height: 1rem;
    border-width: 0.15em;
}

/* Empty State */
.empty-state {
    padding: 3rem;
}

.empty-icon {
    opacity: 0.5;
}

/* Dropdown Menu */
.dropdown-menu {
    border: none;
    border-radius: 12px;
    padding: 0.5rem;
    min-width: 200px;
    margin-top: 0.5rem !important;
}

.dropdown-item {
    border-radius: 8px;
    padding: 0.5rem 1rem;
    transition: all 0.2s ease;
}

.dropdown-item:hover {
    background-color: rgba(102, 126, 234, 0.1);
    transform: translateX(5px);
}

.dropdown-divider {
    margin: 0.5rem;
}

/* Fix dropdown overlap */
.table td:last-child {
    position: relative;
    overflow: visible;
}

.dropdown .dropdown-menu {
    position: absolute;
    inset: 0px auto auto 0px;
    margin: 0px;
    transform: translate3d(0px, 38px, 0px);
}

.dropdown-menu.dropdown-menu-end {
    right: 0;
    left: auto;
}

/* Remove dropdown arrow if not needed */
.dropdown-toggle::after {
    display: none;
}

/* Form Controls */
.form-control, .form-select {
    border-radius: 10px;
    border: 1px solid #e0e6ed;
    transition: all 0.2s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
}

/* Custom Scrollbar */
::-webkit-scrollbar {
    width: 8px;
    height: 8px;
}

::-webkit-scrollbar-track {
    background: #f1f1f1;
}

::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 4px;
}

::-webkit-scrollbar-thumb:hover {
    background: #555;
}

/* Animations */
@keyframes slideInUp {
    from {
        transform: translateY(20px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

.loan-row {
    animation: slideInUp 0.5s ease forwards;
}

.loan-row:nth-child(1) { animation-delay: 0.05s; }
.loan-row:nth-child(2) { animation-delay: 0.1s; }
.loan-row:nth-child(3) { animation-delay: 0.15s; }
.loan-row:nth-child(4) { animation-delay: 0.2s; }
.loan-row:nth-child(5) { animation-delay: 0.25s; }

/* Modern Interactive Elements */
.btn {
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    z-index: 1;
}

.btn::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.5);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
    z-index: -1;
}

.btn:hover::before {
    width: 300px;
    height: 300px;
}

/* Modern Table Design */
.table-container {
    background: rgba(255, 255, 255, 0.98);
    border-radius: 20px;
    padding: 1.5rem;
    box-shadow: 0 10px 30px rgba(23, 71, 158, 0.08);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(23, 71, 158, 0.08);
}

.table {
    margin-bottom: 0;
}

/* Compact table for better space utilization */
.table td {
    padding: 0.4rem 0.5rem;
    vertical-align: middle;
    font-size: 0.813rem;
}

/* Alternating row colors with URA brand */
.table tbody tr:nth-child(even) {
    background-color: rgba(23, 71, 158, 0.02);
}

.table th {
    padding: 0.5rem;
    font-size: 0.813rem;
    font-weight: 600;
}

/* Smaller text for secondary information */
.table small {
    font-size: 0.75rem;
}

/* Compact badges */
.table .badge {
    font-size: 0.7rem;
    padding: 0.2rem 0.4rem;
}

/* Compact dropdown */
.dropdown-menu {
    font-size: 0.813rem;
    min-width: 120px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    z-index: 9999 !important;
    background-color: white;
}

.dropdown-item {
    padding: 0.4rem 1rem;
    cursor: pointer;
}

.dropdown-item:hover {
    background-color: rgba(23, 71, 158, 0.1);
}

.dropdown-item i {
    font-size: 0.75rem;
    width: 16px;
}

/* Fix dropdown positioning */
.table-responsive {
    min-height: 300px;
}

/* Ensure dropdown menu appears on top */
.dropdown-menu {
    z-index: 99999 !important;
    background-color: white !important;
    border: 1px solid rgba(0,0,0,0.15) !important;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1) !important;
}

/* Process Loan Action Cards */
.action-card {
    cursor: pointer;
    transition: all 0.3s ease;
    border: 2px solid #dee2e6 !important;
}

.action-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    border-color: #17479E !important;
}

.action-card.border-primary {
    border-color: #17479E !important;
    background-color: rgba(23, 71, 158, 0.05) !important;
}

.action-icon {
    width: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.hover-shadow:hover {
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

/* Action button hover effects */
.btn-sm:hover {
    transform: scale(1.2);
    transition: all 0.2s ease;
}

.btn-sm:hover i.fa-eye {
    color: #0056b3 !important;
}

.btn-sm:hover i.fa-edit {
    color: #545b62 !important;
}

.btn-sm:hover i.fa-check {
    color: #218838 !important;
}

.btn-sm:hover i.fa-times {
    color: #c82333 !important;
}

.table th {
    font-weight: 700;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 1px;
    color: #17479E;
    border-bottom: 2px solid rgba(23, 71, 158, 0.1);
    padding: 1rem;
}

.table td {
    padding: 1rem;
    vertical-align: middle;
    border-bottom: 1px solid rgba(23, 71, 158, 0.05);
}

.table tbody tr {
    transition: all 0.3s ease;
}

.table tbody tr:hover {
    background: linear-gradient(90deg, 
        rgba(23, 71, 158, 0.02) 0%, 
        rgba(23, 71, 158, 0.05) 50%, 
        rgba(23, 71, 158, 0.02) 100%);
}

/* Status Badges with Modern Style */
.badge {
    padding: 8px 16px;
    border-radius: 50px;
    font-weight: 600;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    text-transform: uppercase;
    position: relative;
    overflow: hidden;
}

.badge::before {
    content: '';
    position: absolute;
    top: 50%;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, 
        transparent, 
        rgba(255, 255, 255, 0.3), 
        transparent);
    animation: badgeShimmer 3s ease-in-out infinite;
}

@keyframes badgeShimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(300%); }
}

/* Action Buttons with Micro-interactions */
.btn-action {
    width: 35px;
    height: 35px;
    border-radius: 10px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    border: 1px solid transparent;
    position: relative;
    margin: 0 2px;
}

.btn-action:hover {
    transform: translateY(-3px) scale(1.1);
    border-color: currentColor;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
}

.btn-action::after {
    content: '';
    position: absolute;
    inset: -2px;
    border-radius: 10px;
    background: linear-gradient(45deg, currentColor, transparent);
    opacity: 0;
    transition: opacity 0.3s ease;
    z-index: -1;
}

.btn-action:hover::after {
    opacity: 0.2;
}

/* URASACCOS Brand Enhancements */
.text-primary {
    color: #17479E !important;
}

.bg-primary {
    background: #17479E !important;
}

.border-primary {
    border-color: #17479E !important;
}

/* Enhanced Table Headers with URASACCOS Style */
.table thead th {
    background: linear-gradient(135deg, rgba(23, 71, 158, 0.1) 0%, rgba(23, 71, 158, 0.05) 100%);
    color: #17479E;
    font-weight: 700;
    text-transform: uppercase;
    font-size: 0.85rem;
    letter-spacing: 0.5px;
    border-bottom: 2px solid rgba(23, 71, 158, 0.3);
}

/* Status Colors with URASACCOS Theme */
.status-approved {
    color: #1e8449;
    background: rgba(30, 132, 73, 0.1);
    padding: 4px 8px;
    border-radius: 4px;
}

.status-pending {
    color: #f39c12;
    background: rgba(243, 156, 18, 0.1);
    padding: 4px 8px;
    border-radius: 4px;
}

/* Dropdown Menu URASACCOS Style */
.dropdown-menu {
    border: 1px solid rgba(23, 71, 158, 0.1);
    box-shadow: 0 5px 20px rgba(23, 71, 158, 0.15);
}

.dropdown-item:hover {
    background: linear-gradient(135deg, rgba(23, 71, 158, 0.1) 0%, rgba(23, 71, 158, 0.05) 100%);
    color: #17479E;
}

/* Pagination URASACCOS Style */
.pagination .page-link {
    color: #17479E;
    border-color: rgba(23, 71, 158, 0.2);
}

.pagination .page-item.active .page-link {
    background: linear-gradient(135deg, #17479E 0%, #2563c7 100%);
    border-color: #17479E;
}

/* Add URASACCOS branding watermark */
.page-header-wrapper::before {
    content: 'URASACCOS';
    position: absolute;
    top: 50%;
    right: 2rem;
    transform: translateY(-50%);
    font-size: 3rem;
    font-weight: 900;
    color: rgba(23, 71, 158, 0.05);
    letter-spacing: 3px;
    pointer-events: none;
}

/* Advanced Glassmorphism Effects */
.glass-effect {
    background: linear-gradient(
        135deg,
        rgba(255, 255, 255, 0.1) 0%,
        rgba(255, 255, 255, 0.05) 100%
    );
    backdrop-filter: blur(10px) saturate(150%);
    -webkit-backdrop-filter: blur(10px) saturate(150%);
    border: 1px solid rgba(255, 255, 255, 0.18);
    box-shadow: 
        0 8px 32px 0 rgba(31, 38, 135, 0.37),
        inset 0 0 0 1px rgba(255, 255, 255, 0.1);
}

/* Neon Glow Effects */
.neon-glow {
    animation: neonPulse 2s ease-in-out infinite;
}

@keyframes neonPulse {
    0%, 100% {
        text-shadow: 
            0 0 5px var(--ura-primary),
            0 0 10px var(--ura-primary),
            0 0 15px var(--ura-primary),
            0 0 20px var(--ura-primary-light);
    }
    50% {
        text-shadow: 
            0 0 10px var(--ura-primary),
            0 0 20px var(--ura-primary),
            0 0 30px var(--ura-primary),
            0 0 40px var(--ura-primary-light);
    }
}

/* 3D Card Tilt Effect */
.tilt-card {
    transform-style: preserve-3d;
    transition: transform 0.6s;
}

.tilt-card:hover {
    transform: 
        perspective(1000px) 
        rotateX(10deg) 
        rotateY(-10deg) 
        scale(1.05);
}

/* Liquid Button Effect */
.liquid-btn {
    position: relative;
    padding: 20px 40px;
    display: block;
    text-decoration: none;
    overflow: hidden;
    transition: all 0.3s;
}

.liquid-btn span {
    position: relative;
    z-index: 1;
}

.liquid-btn::before {
    content: '';
    position: absolute;
    top: var(--y, 50%);
    left: var(--x, 50%);
    width: 0;
    height: 0;
    border-radius: 50%;
    background: var(--ura-primary-light);
    transition: width 0.5s, height 0.5s;
    transform: translate(-50%, -50%);
}

.liquid-btn:hover::before {
    width: 400px;
    height: 400px;
}

/* Skeleton Loading Animation */
.skeleton {
    position: relative;
    overflow: hidden;
    background: linear-gradient(
        90deg,
        #f0f0f0 25%,
        #e0e0e0 50%,
        #f0f0f0 75%
    );
    background-size: 200% 100%;
    animation: skeletonLoading 1.5s infinite;
}

@keyframes skeletonLoading {
    0% {
        background-position: 200% 0;
    }
    100% {
        background-position: -200% 0;
    }
}

/* Morphing Search Bar */
.search-morphing {
    position: relative;
    transition: all 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
}

.search-morphing:focus-within {
    transform: scale(1.05);
    box-shadow: 
        0 10px 40px rgba(23, 71, 158, 0.2),
        inset 0 0 0 2px var(--ura-primary);
}

/* Gradient Text Animation */
.gradient-text-animated {
    background: linear-gradient(
        270deg,
        var(--ura-primary),
        var(--ura-primary-light),
        var(--ura-secondary),
        var(--ura-accent)
    );
    background-size: 400% 400%;
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    animation: gradientShift 3s ease infinite;
}

@keyframes gradientShift {
    0% { background-position: 0% 50%; }
    50% { background-position: 100% 50%; }
    100% { background-position: 0% 50%; }
}

/* Floating Action Button */
.fab {
    position: fixed;
    bottom: 2rem;
    right: 2rem;
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: var(--ura-gradient);
    box-shadow: 
        0 10px 30px rgba(23, 71, 158, 0.3),
        0 5px 15px rgba(0, 0, 0, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    cursor: pointer;
    transition: all 0.3s;
    z-index: 1000;
}

.fab:hover {
    transform: scale(1.1) rotate(90deg);
    box-shadow: 
        0 15px 40px rgba(23, 71, 158, 0.4),
        0 10px 25px rgba(0, 0, 0, 0.3);
}

/* Ripple Effect */
.ripple {
    position: relative;
    overflow: hidden;
}

.ripple::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.5);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
}

.ripple:active::before {
    width: 300px;
    height: 300px;
}

/* Quick Actions Menu */
.quick-actions-menu {
    position: fixed;
    bottom: 5rem;
    right: 2rem;
    display: flex;
    flex-direction: column;
    gap: 1rem;
    opacity: 0;
    pointer-events: none;
    transform: scale(0.8) translateY(20px);
    transition: all 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
    z-index: 999;
}

.quick-actions-menu.show {
    opacity: 1;
    pointer-events: all;
    transform: scale(1) translateY(0);
}

.quick-action-btn {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    border: none;
    background: white;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    color: var(--ura-primary);
    font-size: 1.2rem;
    cursor: pointer;
    transition: all 0.3s;
    position: relative;
}

.quick-action-btn:hover {
    background: var(--ura-gradient);
    color: white;
    transform: scale(1.1);
    box-shadow: 0 8px 25px rgba(23, 71, 158, 0.3);
}

.quick-action-btn[data-tooltip]::before {
    content: attr(data-tooltip);
    position: absolute;
    right: 60px;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(0, 0, 0, 0.8);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 0.5rem;
    font-size: 0.875rem;
    white-space: nowrap;
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s;
}

.quick-action-btn:hover[data-tooltip]::before {
    opacity: 1;
}

/* Loading Overlay */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(5px);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.loading-overlay.show {
    display: flex;
}

.loading-spinner {
    text-align: center;
}

.loading-spinner .spinner-border {
    width: 3rem;
    height: 3rem;
    border-width: 0.3rem;
}

/* Toast Notifications */
.toast-notification {
    background: white;
    border-radius: 12px;
    padding: 1rem 1.5rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    animation: slideInRight 0.3s ease;
    max-width: 350px;
}

@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

.toast-notification.success {
    border-left: 4px solid var(--ura-secondary);
}

.toast-notification.error {
    border-left: 4px solid #e74c3c;
}

.toast-notification.info {
    border-left: 4px solid var(--ura-primary);
}

/* Simplified Table Styling */
.avatar-initials {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 0.875rem;
}

.bg-gradient-blue {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.bg-gradient-pink {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.btn-ura-primary {
    background: var(--ura-primary);
    color: white;
    border: none;
    transition: all 0.3s ease;
}

.btn-ura-primary:hover {
    background: var(--ura-primary-dark);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(23, 71, 158, 0.3);
}

/* Enhanced Modal Styling with URASACCOS Branding */
.modal-ura-enhanced {
    border-radius: 20px;
    overflow: hidden;
    background: white;
}

.shadow-2xl {
    box-shadow: 
        0 25px 50px -12px rgba(0, 0, 0, 0.25),
        0 0 0 1px rgba(23, 71, 158, 0.05);
}

/* Modal Pattern Background */
.modal-pattern {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 200px;
    background: 
        repeating-linear-gradient(
            45deg,
            transparent,
            transparent 10px,
            rgba(23, 71, 158, 0.01) 10px,
            rgba(23, 71, 158, 0.01) 20px
        );
    pointer-events: none;
    z-index: 0;
}

/* Modal Header Styling */
.modal-header-ura {
    background: var(--ura-gradient);
    padding: 2rem;
    position: relative;
}

.header-decoration {
    position: absolute;
    top: -50%;
    right: -10%;
    width: 300px;
    height: 300px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.05);
    animation: floatBubble 20s infinite ease-in-out;
}

@keyframes floatBubble {
    0%, 100% { transform: translate(0, 0) scale(1); }
    33% { transform: translate(30px, -30px) scale(1.1); }
    66% { transform: translate(-20px, 20px) scale(0.9); }
}

.modal-icon-wrapper {
    position: relative;
}

.modal-icon-circle {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
    backdrop-filter: blur(10px);
    animation: pulseIcon 2s infinite;
}

@keyframes pulseIcon {
    0%, 100% {
        box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4);
    }
    50% {
        box-shadow: 0 0 0 15px rgba(255, 255, 255, 0);
    }
}

/* Enhanced Tab Navigation */
.tab-navigation-wrapper {
    background: linear-gradient(to bottom, #f8f9fa, white);
    padding: 0.5rem;
    border-bottom: 1px solid rgba(23, 71, 158, 0.1);
}

.nav-tabs-ura {
    gap: 0.5rem;
}

.nav-link-ura {
    position: relative;
    padding: 1rem 1.5rem;
    border-radius: 12px 12px 0 0;
    background: transparent;
    color: #6c757d;
    border: none;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
}

.nav-link-ura:hover {
    background: rgba(23, 71, 158, 0.05);
    color: var(--ura-primary);
    transform: translateY(-2px);
}

.nav-link-ura.active {
    background: white;
    color: var(--ura-primary);
    box-shadow: 
        0 -2px 10px rgba(23, 71, 158, 0.1),
        0 2px 4px rgba(0, 0, 0, 0.05);
}

.tab-icon-box {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, rgba(23, 71, 158, 0.1), rgba(23, 71, 158, .05));
    transition: all 0.3s ease;
    font-size: 1.2rem;
}

.nav-link-ura.active .tab-icon-box {
    background: var(--ura-gradient);
    color: white;
    animation: rotateIcon 0.5s ease;
}

@keyframes rotateIcon {
    from { transform: rotate(0deg) scale(0.8); }
    to { transform: rotate(360deg) scale(1); }
}

.tab-label {
    font-size: 0.875rem;
    font-weight: 600;
    letter-spacing: 0.5px;
}

.tab-indicator {
    position: absolute;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%) scaleX(0);
    width: 50px;
    height: 3px;
    background: var(--ura-gradient);
    border-radius: 3px 3px 0 0;
    transition: transform 0.3s ease;
}

.nav-link-ura.active .tab-indicator {
    transform: translateX(-50%) scaleX(1);
}

/* Enhanced Info Cards */
.info-card-enhanced {
    background: white;
    border-radius: 16px;
    border: 1px solid rgba(23, 71, 158, 0.08);
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
}

.info-card-enhanced:hover {
    transform: translateY(-4px);
    box-shadow: 
        0 12px 24px rgba(23, 71, 158, 0.12),
        0 4px 8px rgba(0, 0, 0, 0.05);
    border-color: var(--ura-primary);
}

.info-card-header {
    background: linear-gradient(135deg, rgba(23, 71, 158, 0.05), rgba(23, 71, 158, 0.02));
    padding: 1rem;
    border-bottom: 2px solid rgba(23, 71, 158, 0.1);
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.info-card-icon {
    width: 35px;
    height: 35px;
    background: var(--ura-gradient);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
    flex-shrink: 0;
}

.info-card-title {
    margin: 0;
    color: var(--ura-primary);
    font-weight: 600;
    font-size: 1rem;
}

.info-card-body {
    padding: 1rem;
}

.info-item {
    padding: 0.75rem 0;
    border-bottom: 1px dashed rgba(23, 71, 158, 0.1);
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
    transition: all 0.2s ease;
}

.info-item:hover {
    padding-left: 0.5rem;
    background: rgba(23, 71, 158, 0.02);
    margin: 0 -0.5rem;
    padding-right: 0.5rem;
}

.info-item:last-child {
    border-bottom: none;
}

.info-item small {
    color: #6c757d;
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-weight: 600;
}

.info-item div {
    color: #2c3e50;
    font-weight: 500;
}

/* Enhanced Modal Footer */
.modal-footer-ura {
    background: linear-gradient(to right, #f8f9fa, white);
    padding: 1.5rem;
    border-top: 2px solid rgba(23, 71, 158, 0.1);
}

.btn-ura-gradient {
    background: var(--ura-gradient);
    color: white;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-ura-gradient::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
}

.btn-ura-gradient:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 20px rgba(23, 71, 158, 0.3);
    color: white;
}

.btn-ura-gradient:hover::before {
    width: 300px;
    height: 300px;
}

/* Loading States */
.modal-loading {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.95);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s ease;
}

.modal-loading.show {
    opacity: 1;
    pointer-events: all;
}

/* Badge Enhancements */
.badge {
    padding: 0.5rem 0.75rem;
    border-radius: 8px;
    font-weight: 600;
    letter-spacing: 0.3px;
    transition: all 0.2s ease;
}

.badge:hover {
    transform: scale(1.05);
}

/* Tab Content Animation */
.tab-pane {
    animation: fadeInUp 0.4s ease;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.bg-ura-gradient {
    background: var(--ura-gradient);
    color: white;
}

/* Scrollbar Styling for Modal */
.modal-dialog-scrollable .modal-body::-webkit-scrollbar {
    width: 8px;
}

.modal-dialog-scrollable .modal-body::-webkit-scrollbar-track {
    background: rgba(23, 71, 158, 0.05);
    border-radius: 4px;
}

.modal-dialog-scrollable .modal-body::-webkit-scrollbar-thumb {
    background: rgba(23, 71, 158, 0.3);
    border-radius: 4px;
}

.modal-dialog-scrollable .modal-body::-webkit-scrollbar-thumb:hover {
    background: var(--ura-primary);
}

.bg-ura-gradient th {
    font-weight: 600;
    letter-spacing: 0.5px;
    padding: 1rem;
}

/* Glitch Effect */
.glitch {
    position: relative;
    color: var(--ura-primary);
    font-weight: bold;
}

.glitch::before,
.glitch::after {
    content: attr(data-text);
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}

.glitch::before {
    animation: glitch-1 0.3s infinite;
    color: var(--ura-accent);
    z-index: -1;
}

.glitch::after {
    animation: glitch-2 0.3s infinite;
    color: var(--ura-secondary);
    z-index: -2;
}

@keyframes glitch-1 {
    0%, 100% {
        clip: rect(0, 900px, 0, 0);
        transform: skew(0deg);
    }
    20% {
        clip: rect(20px, 900px, 30px, 0);
        transform: skew(0.5deg);
    }
}

@keyframes glitch-2 {
    0%, 100% {
        clip: rect(0, 900px, 0, 0);
        transform: skew(0deg);
    }
    50% {
        clip: rect(50px, 900px, 60px, 0);
        transform: skew(-0.5deg);
    }
}
</style>
@endpush

@push('scripts')
<script>
// Animated Counter Effect
function animateCounters() {
    const counters = document.querySelectorAll('.counter-animation');
    
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-value'));
        const duration = 2000;
        const step = target / (duration / 16);
        let current = 0;
        
        const updateCounter = () => {
            current += step;
            if (current < target) {
                counter.textContent = Math.floor(current);
                requestAnimationFrame(updateCounter);
            } else {
                counter.textContent = target;
            }
        };
        
        updateCounter();
    });
}

// Magnetic Button Effect
document.querySelectorAll('.magnetic-btn').forEach(btn => {
    btn.addEventListener('mousemove', (e) => {
        const rect = btn.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        
        btn.style.setProperty('--x', `${x}px`);
        btn.style.setProperty('--y', `${y}px`);
    });
});

// Parallax Scroll Effect
window.addEventListener('scroll', () => {
    const scrolled = window.pageYOffset;
    const parallax = document.querySelector('.blob-container');
    const particles = document.querySelector('.particle-container');
    
    if (parallax) {
        parallax.style.transform = `translateY(${scrolled * 0.5}px)`;
    }
    
    if (particles) {
        particles.style.transform = `translateY(${scrolled * 0.3}px)`;
    }
});

// Show Quick Actions Menu
function showQuickActions() {
    const menu = document.getElementById('quick-actions');
    const fab = document.querySelector('.fab');
    
    if (menu.classList.contains('show')) {
        menu.classList.remove('show');
        fab.style.transform = 'scale(1) rotate(0deg)';
    } else {
        menu.classList.add('show');
        fab.style.transform = 'scale(1.1) rotate(45deg)';
    }
}

// Show Toast Notification
function showToast(message, type = 'info') {
    const container = document.getElementById('toast-container');
    const toast = document.createElement('div');
    toast.className = `toast-notification ${type}`;
    
    const icon = {
        success: 'fa-check-circle',
        error: 'fa-exclamation-circle',
        info: 'fa-info-circle'
    }[type];
    
    toast.innerHTML = `
        <i class="fas ${icon} fs-4"></i>
        <div>
            <strong>${type.charAt(0).toUpperCase() + type.slice(1)}</strong>
            <p class="mb-0 text-muted small">${message}</p>
        </div>
    `;
    
    container.appendChild(toast);
    
    setTimeout(() => {
        toast.style.animation = 'slideInRight 0.3s ease reverse';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
}

// Show Loading Overlay
function showLoading() {
    document.getElementById('loading-overlay').classList.add('show');
}

function hideLoading() {
    document.getElementById('loading-overlay').classList.remove('show');
}

// Initialize Animations on Load
window.addEventListener('load', () => {
    animateCounters();
    
    // Add intersection observer for scroll animations
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -100px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('animate-in');
            }
        });
    }, observerOptions);
    
    document.querySelectorAll('.stat-card').forEach(card => {
        observer.observe(card);
    });
});

// Liquid Button Mouse Tracking
document.querySelectorAll('.liquid-btn').forEach(btn => {
    btn.addEventListener('mousemove', (e) => {
        const rect = btn.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        
        btn.style.setProperty('--x', `${x}px`);
        btn.style.setProperty('--y', `${y}px`);
    });
});

// Add Ripple Effect
function createRipple(event) {
    const button = event.currentTarget;
    const ripple = document.createElement('span');
    const rect = button.getBoundingClientRect();
    const size = Math.max(rect.width, rect.height);
    const x = event.clientX - rect.left - size / 2;
    const y = event.clientY - rect.top - size / 2;
    
    ripple.style.width = ripple.style.height = size + 'px';
    ripple.style.left = x + 'px';
    ripple.style.top = y + 'px';
    ripple.classList.add('ripple-effect');
    
    button.appendChild(ripple);
    
    setTimeout(() => ripple.remove(), 600);
}

document.querySelectorAll('.ripple').forEach(btn => {
    btn.addEventListener('click', createRipple);
});
// Note: Modal population is handled by the event listener in DOMContentLoaded
// These functions are kept for backwards compatibility if needed

// Legacy function for backwards compatibility
function populateLoanModal(button) {
    console.log('populateLoanModal called (legacy function)');
    // This is now handled by the modal show.bs.modal event listener
}

// Legacy function for backwards compatibility  
function showLoanDetails(loanData) {
    console.log('showLoanDetails called (legacy function)');
    // This is now handled by the modal show.bs.modal event listener
}

// Helper function to safely set element text
function setElementText(elementId, value) {
    const element = document.getElementById(elementId);
    if (element) {
        // Ensure we always display something, even if value is null/undefined/empty
        const displayValue = value !== null && value !== undefined && value !== '' ? value : 'N/A';
        element.textContent = displayValue;
        console.log(`Set ${elementId} to: ${displayValue}`);
    } else {
        console.warn(`Element with id '${elementId}' not found`);
    }
}

// Helper function to safely set element HTML
function setElementHTML(elementId, html) {
    const element = document.getElementById(elementId);
    if (element) {
        element.innerHTML = html || 'N/A';
    } else {
        console.warn(`Element with id '${elementId}' not found`);
    }
}

// Helper function to format currency
function formatCurrency(amount) {
    if (!amount || amount === null || amount === undefined || amount === '' || isNaN(amount)) {
        return 'N/A';
    }
    return parseFloat(amount).toLocaleString('en-US', { maximumFractionDigits: 0 }) + ' TZS';
}

// Helper function to format dates
function formatDateValue(dateStr) {
    if (!dateStr || dateStr === null || dateStr === undefined || dateStr === '') {
        return 'N/A';
    }
    try {
        const date = new Date(dateStr);
        if (isNaN(date.getTime())) {
            return 'N/A';
        }
        return date.toLocaleDateString('en-US', { year: 'numeric', month: 'short', day: 'numeric' });
    } catch (e) {
        return dateStr || 'N/A';
    }
}

// Helper function to get approval badge HTML
function getApprovalBadgeHTML(approval) {
    switch(approval) {
        case 'APPROVED':
            return '<span class="badge bg-success"><i class="fas fa-check me-1"></i>Approved</span>';
        case 'REJECTED':
            return '<span class="badge bg-danger"><i class="fas fa-times me-1"></i>Rejected</span>';
        case 'PENDING':
        case null:
        case undefined:
        case '':
            return '<span class="badge bg-warning"><i class="fas fa-clock me-1"></i>Pending</span>';
        default:
            return '<span class="badge bg-secondary">' + approval + '</span>';
    }
}

// Helper function to get status badge HTML
function getStatusBadgeHTML(status) {
    if (!status) {
        return '<span class="badge bg-secondary">New</span>';
    }
    
    switch(status.toLowerCase()) {
        case 'disbursed':
            return '<span class="badge bg-success"><i class="fas fa-check-circle me-1"></i>Disbursed</span>';
        case 'disbursement_pending':
            return '<span class="badge bg-info"><i class="fas fa-hourglass-half me-1"></i>NMB Processing</span>';
        case 'disbursement_failed':
            return '<span class="badge bg-danger"><i class="fas fa-exclamation-triangle me-1"></i>Failed</span>';
        case 'full_settled':
            return '<span class="badge bg-dark"><i class="fas fa-handshake me-1"></i>Settled</span>';
        default:
            return '<span class="badge bg-secondary">' + status + '</span>';
    }
}

// Test function to manually open modal
function testModal() {
    const modalElement = document.getElementById('loanDetailsModal');
    if (modalElement) {
        console.log('Modal element found');
        if (typeof bootstrap !== 'undefined') {
            console.log('Bootstrap is loaded');
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('Bootstrap is not loaded!');
            // Fallback: try jQuery modal
            if (typeof $ !== 'undefined' && $.fn.modal) {
                console.log('Using jQuery modal');
                $('#loanDetailsModal').modal('show');
            } else {
                console.error('Neither Bootstrap nor jQuery modal available');
            }
        }
    } else {
        console.error('Modal element not found');
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, initializing...');
    
    // Check if Bootstrap is available
    if (typeof bootstrap === 'undefined') {
        console.error('Bootstrap is not loaded on DOMContentLoaded');
    } else {
        console.log('Bootstrap is available');
    }
    
    // Initialize tooltips
    initializeTooltips();
    
    // Initialize animations
    animateNumbers();
    
    // Setup event listeners
    setupEventListeners();
    
    // Initialize Bootstrap dropdowns (ensure they work)
    var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'));
    var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
        return new bootstrap.Dropdown(dropdownToggleEl);
    });
    
    // Setup modal event listener
    const loanModal = document.getElementById('loanDetailsModal');
    if (loanModal) {
        loanModal.addEventListener('show.bs.modal', function (event) {
            console.log('Modal is opening...');
            const button = event.relatedTarget; // Button that triggered the modal
            if (button) {
                console.log('Triggered by button:', button);
                
                // Get the loan data from the button
                const loanDataStr = button.getAttribute('data-loan');
                console.log('Raw loan data:', loanDataStr);
                
                let loan;
                try {
                    loan = JSON.parse(loanDataStr);
                    console.log('Parsed loan data:', loan);
                    console.log('Available loan fields:', Object.keys(loan));
                } catch (e) {
                    console.error('Error parsing loan data:', e);
                    alert('Error loading loan details');
                    return;
                }
                
                // Populate all modal fields
                // Personal Information
                const fullName = `${loan.first_name || ''} ${loan.middle_name || ''} ${loan.last_name || ''}`.trim();
                console.log('Setting personal info - Full Name:', fullName);
                setElementText('modal-full-name', fullName || 'N/A');
                setElementText('modal-check-number', loan.check_number || 'N/A');
                setElementText('modal-nin', loan.nin || 'N/A');
                setElementText('modal-sex', loan.sex === 'M' ? 'Male' : loan.sex === 'F' ? 'Female' : 'N/A');
                setElementText('modal-marital-status', loan.marital_status || 'N/A');
                
                // Contact Information  
                console.log('Setting contact info...');
                setElementText('modal-mobile', loan.mobile_number || 'N/A');
                setElementText('modal-email', loan.email_address || 'N/A');
                setElementText('modal-telephone', loan.telephone_number || 'N/A');
                setElementText('modal-address', loan.physical_address || 'N/A');
                
                // Employment Information
                console.log('Setting employment info...');
                setElementText('modal-designation', loan.designation_name || 'N/A');
                setElementText('modal-vote-name', loan.vote_name || 'N/A');
                setElementText('modal-vote-code', loan.vote_code || 'N/A');
                setElementText('modal-terms', loan.terms_of_employment || 'N/A');
                setElementText('modal-employment-date', formatDateValue(loan.employment_date));
                setElementText('modal-confirmation-date', formatDateValue(loan.confirmation_date));
                setElementText('modal-retirement-date', formatDateValue(loan.retirement_date));
                
                // Loan Information
                console.log('Setting loan info...');
                setElementText('modal-app-number', loan.application_number || 'PENDING');
                setElementText('modal-loan-purpose', loan.loan_purpose || 'N/A');
                setElementText('modal-fsp-ref', loan.fsp_reference_number || 'N/A');
                setElementText('modal-loan-number', loan.loan_number || 'N/A');
                setElementText('modal-tenure', loan.tenure ? `${loan.tenure} months` : 'N/A');
                setElementText('modal-interest-rate', loan.interest_rate ? `${loan.interest_rate}%` : 'N/A');
                setElementText('modal-processing-fee', formatCurrency(loan.processing_fee));
                setElementText('modal-insurance', formatCurrency(loan.insurance));
                
                // Financial Information
                console.log('Setting financial info...');
                setElementText('modal-basic-salary', formatCurrency(loan.basic_salary));
                setElementText('modal-net-salary', formatCurrency(loan.net_salary));
                setElementText('modal-one-third', formatCurrency(loan.one_third_amount));
                setElementText('modal-deductions', formatCurrency(loan.total_employee_deduction));
                setElementText('modal-requested-amount', formatCurrency(loan.requested_amount));
                setElementText('modal-total-amount', formatCurrency(loan.total_amount_to_pay));
                setElementText('modal-monthly-deduction', formatCurrency(loan.desired_deductible_amount));
                setElementText('modal-other-charges', formatCurrency(loan.other_charges));
                
                // Banking Information
                console.log('Setting banking info...');
                setElementText('modal-account-number', loan.bank_account_number || 'N/A');
                setElementText('modal-swift-code', loan.swift_code || 'N/A');
                setElementText('modal-branch-name', loan.nearest_branch_name || 'N/A');
                setElementText('modal-branch-code', loan.nearest_branch_code || 'N/A');
                
                // Status Information
                console.log('Setting status info...');
                setElementHTML('modal-approval-status', getApprovalBadgeHTML(loan.approval));
                setElementHTML('modal-processing-status', getStatusBadgeHTML(loan.status));
                setElementText('modal-created-date', formatDateValue(loan.created_at));
                setElementText('modal-updated-date', formatDateValue(loan.updated_at));
                
                // Process Loan Tab - Set current status
                setElementHTML('process-current-approval', getApprovalBadgeHTML(loan.approval));
                setElementHTML('process-current-status', getStatusBadgeHTML(loan.status));
                document.getElementById('process-loan-id').value = loan.id;
                
                console.log('All modal fields populated');
                
                // Initialize Bootstrap tabs properly
                setTimeout(() => {
                    // Remove any existing active classes and reset tabs
                    document.querySelectorAll('.nav-tabs-ura .nav-link').forEach(tab => {
                        tab.classList.remove('active');
                    });
                    document.querySelectorAll('.tab-pane').forEach(pane => {
                        pane.classList.remove('show', 'active');
                    });
                    
                    // Set the first tab as active
                    const firstTab = document.querySelector('.nav-tabs-ura .nav-link[href="#personal-info"]');
                    const firstPane = document.getElementById('personal-info');
                    
                    if (firstTab && firstPane) {
                        firstTab.classList.add('active');
                        firstPane.classList.add('show', 'active', 'fade');
                        console.log('Reset tabs to Personal Information');
                    }
                    
                    // Re-initialize all tab click handlers
                    document.querySelectorAll('.nav-tabs-ura .nav-link').forEach(tabLink => {
                        tabLink.addEventListener('click', function(e) {
                            e.preventDefault();
                            const tab = new bootstrap.Tab(this);
                            tab.show();
                            console.log('Switched to tab:', this.getAttribute('href'));
                        });
                    });
                }, 100);
            }
        });
    } else {
        console.error('Loan modal element not found during initialization');
    }
});

// Initialize tooltips
function initializeTooltips() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    });
}

// Animate numbers on load
function animateNumbers() {
    document.querySelectorAll('.stat-number').forEach(element => {
        const target = parseInt(element.getAttribute('data-value') || element.innerText);
        let current = 0;
        const increment = target / 50;
        const timer = setInterval(() => {
            current += increment;
            if (current >= target) {
                current = target;
                clearInterval(timer);
            }
            element.innerText = Math.floor(current).toLocaleString();
        }, 20);
    });
}

// Setup event listeners
function setupEventListeners() {
    // Select all checkbox
    const selectAll = document.getElementById('select-all');
    if (selectAll) {
        selectAll.addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('.loan-checkbox');
            checkboxes.forEach(cb => {
                cb.checked = this.checked;
                updateRowSelection(cb);
            });
            updateBulkActions();
        });
    }
    
    // Individual checkboxes
    document.querySelectorAll('.loan-checkbox').forEach(cb => {
        cb.addEventListener('change', function() {
            updateRowSelection(this);
            updateBulkActions();
        });
    });
}

// Update row selection state
function updateRowSelection(checkbox) {
    const row = checkbox.closest('tr');
    if (checkbox.checked) {
        row.classList.add('table-active');
    } else {
        row.classList.remove('table-active');
    }
}

// Update bulk actions count
function updateBulkActions() {
    const selected = document.querySelectorAll('.loan-checkbox:checked').length;
    const selectedCount = document.getElementById('selected-count');
    if (selectedCount) {
        selectedCount.textContent = selected;
    }
    
    // Show/hide bulk actions
    if (selected > 0) {
        showBulkActionsBar(selected);
    } else {
        hideBulkActionsBar();
    }
}

// Show bulk actions bar
function showBulkActionsBar(count) {
    // Create or update bulk actions floating bar
    let bulkBar = document.getElementById('bulk-actions-bar');
    if (!bulkBar) {
        bulkBar = document.createElement('div');
        bulkBar.id = 'bulk-actions-bar';
        bulkBar.className = 'position-fixed bottom-0 start-50 translate-middle-x mb-4 p-3 bg-white rounded-pill shadow-lg';
        bulkBar.style.zIndex = '1050';
        bulkBar.style.transition = 'all 0.3s ease';
        document.body.appendChild(bulkBar);
    }
    
    bulkBar.innerHTML = `
        <div class="d-flex align-items-center gap-3">
            <span class="text-muted">${count} selected</span>
            <button class="btn btn-sm btn-success" onclick="bulkApprove()">
                <i class="fas fa-check me-1"></i>Approve
            </button>
            <button class="btn btn-sm btn-primary" onclick="bulkDisburse()">
                <i class="fas fa-paper-plane me-1"></i>Disburse
            </button>
            <button class="btn btn-sm btn-danger" onclick="bulkReject()">
                <i class="fas fa-times me-1"></i>Reject
            </button>
            <button class="btn btn-sm btn-light" onclick="clearSelection()">
                <i class="fas fa-times"></i>
            </button>
        </div>
    `;
    
    bulkBar.style.transform = 'translate(-50%, 0)';
}

// Hide bulk actions bar
function hideBulkActionsBar() {
    const bulkBar = document.getElementById('bulk-actions-bar');
    if (bulkBar) {
        bulkBar.style.transform = 'translate(-50%, 100px)';
        setTimeout(() => bulkBar.remove(), 300);
    }
}

// Clear selection
function clearSelection() {
    document.getElementById('select-all').checked = false;
    document.querySelectorAll('.loan-checkbox').forEach(cb => {
        cb.checked = false;
        updateRowSelection(cb);
    });
    updateBulkActions();
}

// Quick disburse - Original version
function quickDisburse(loanId) {
    console.log('Quick disburse called for loan:', loanId);
    
    // Check if Swal is available
    if (typeof Swal === 'undefined') {
        alert('SweetAlert2 library is not loaded. Using default confirm dialog.');
        if (confirm('Send this loan to NMB for processing?')) {
            processQuickDisburse(loanId);
        }
        return;
    }
    
    Swal.fire({
        title: 'Confirm Disbursement',
        text: 'Send this loan to NMB for processing?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, Disburse',
        confirmButtonColor: '#1e8449',
        cancelButtonColor: '#6c757d'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Processing...',
                text: 'Sending to NMB Bank',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // Make AJAX call - check if jQuery is available
            if (typeof $ === 'undefined' && typeof jQuery === 'undefined') {
                console.error('jQuery is not loaded');
                // Use fetch API as fallback
                fetch(`{{ route('loan-offers.update', '') }}/${loanId}`, {
                    method: 'PUT',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        _token: '{{ csrf_token() }}',
                        status: 'SUBMITTED_FOR_DISBURSEMENT'
                    })
                })
                .then(response => response.json())
                .then(data => {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: data.message || 'Loan sent to NMB',
                        timer: 3000
                    }).then(() => {
                        location.reload();
                    });
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Failed to process disbursement'
                    });
                });
            } else {
                // Use jQuery AJAX
                $.ajax({
                    url: `{{ route('loan-offers.update', '') }}/${loanId}`,
                    method: 'PUT',
                    data: {
                        _token: '{{ csrf_token() }}',
                        status: 'SUBMITTED_FOR_DISBURSEMENT'
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message || 'Loan sent to NMB',
                            timer: 3000
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Failed to process disbursement'
                        });
                    }
                });
            }
        }
    });
}

// Sync with ESS with progress indication
function refreshFromESS() {
    // Show sync modal
    const syncModal = Swal.fire({
        title: 'Syncing with ESS',
        html: `
            <div class="text-center">
                <div class="mb-3">
                    <i class="fas fa-sync fa-spin fa-3x text-primary"></i>
                </div>
                <p>Fetching latest loan applications...</p>
                <div class="progress">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" 
                         role="progressbar" style="width: 100%"></div>
                </div>
            </div>
        `,
        allowOutsideClick: false,
        showConfirmButton: false
    });
    
    // Simulate API call
    setTimeout(() => {
        Swal.fire({
            icon: 'success',
            title: 'Sync Complete',
            text: '5 new loan applications retrieved',
            timer: 2000,
            showConfirmButton: false
        }).then(() => {
            location.reload();
        });
    }, 2000);
}

// Sort table
function sortTable(column) {
    const url = new URL(window.location);
    const currentSort = url.searchParams.get('sort');
    const currentOrder = url.searchParams.get('order') || 'asc';
    
    if (currentSort === column) {
        url.searchParams.set('order', currentOrder === 'asc' ? 'desc' : 'asc');
    } else {
        url.searchParams.set('sort', column);
        url.searchParams.set('order', 'asc');
    }
    
    window.location.href = url.toString();
}

// Quick filters
function setQuickFilter(filter) {
    const form = document.getElementById('filter-form');
    const today = new Date();
    
    switch(filter) {
        case 'today':
            form.querySelector('[name="date_from"]').value = today.toISOString().split('T')[0];
            form.querySelector('[name="date_to"]').value = today.toISOString().split('T')[0];
            break;
        case 'week':
            const weekAgo = new Date(today.getTime() - 7 * 24 * 60 * 60 * 1000);
            form.querySelector('[name="date_from"]').value = weekAgo.toISOString().split('T')[0];
            form.querySelector('[name="date_to"]').value = today.toISOString().split('T')[0];
            break;
        case 'month':
            const monthAgo = new Date(today.getFullYear(), today.getMonth() - 1, today.getDate());
            form.querySelector('[name="date_from"]').value = monthAgo.toISOString().split('T')[0];
            form.querySelector('[name="date_to"]').value = today.toISOString().split('T')[0];
            break;
        case 'pending':
            form.querySelector('[name="status"]').value = 'pending_approval';
            break;
        case 'approved':
            form.querySelector('[name="status"]').value = 'approved';
            break;
    }
    
    form.submit();
}

// Clear filters
function clearFilters() {
    const form = document.getElementById('filter-form');
    form.reset();
    window.location.href = '{{ route("loan-offers.index") }}';
}

// Change page size
function changePageSize(size) {
    const url = new URL(window.location);
    url.searchParams.set('per_page', size);
    window.location.href = url.toString();
}

// Export report
function exportReport(format) {
    const selected = Array.from(document.querySelectorAll('.loan-checkbox:checked')).map(cb => cb.value);
    const params = new URLSearchParams(window.location.search);
    params.append('format', format);
    if (selected.length > 0) {
        params.append('selected', selected.join(','));
    }
    
    window.open(`/loan-offers/export?${params.toString()}`, '_blank');
}

// View timeline
function viewTimeline(loanId) {
    console.log('View timeline called for loan:', loanId);
    
    // For now, show a simple timeline modal since the endpoint might not exist yet
    Swal.fire({
        title: 'Activity Timeline',
        html: `
            <div class="text-center">
                <div class="spinner-border text-primary mb-3" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <p>Loading timeline for loan #${loanId}...</p>
            </div>
        `,
        showCloseButton: true,
        showConfirmButton: false,
        didOpen: () => {
            // Try to fetch timeline data
            fetch(`/loan-offers/${loanId}/callbacks`)
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Timeline not available');
                    }
                    // For now just close and show message
                    Swal.fire({
                        title: 'Timeline',
                        text: 'Timeline feature will be available soon',
                        icon: 'info'
                    });
                })
                .catch(error => {
                    console.log('Timeline endpoint not available, showing placeholder');
                    Swal.fire({
                        title: 'Loan Timeline',
                        html: `
                            <div class="timeline-placeholder">
                                <p><strong>Loan ID:</strong> ${loanId}</p>
                                <hr>
                                <div class="text-start">
                                    <p><i class="fas fa-clock text-muted me-2"></i>Application Submitted</p>
                                    <p><i class="fas fa-check-circle text-success me-2"></i>Application Reviewed</p>
                                    <p><i class="fas fa-spinner text-primary me-2"></i>Processing...</p>
                                </div>
                            </div>
                        `,
                        width: '500px',
                        showCloseButton: true,
                        showConfirmButton: false
                    });
                });
        }
    });
}

// Process Loan Modal Functions
let currentLoanData = null;

function selectProcessAction(action) {
    const actionForm = document.getElementById('process-action-form');
    const reasonField = document.getElementById('process-reason-field');
    const actionType = document.getElementById('process-action-type');
    const submitBtn = document.getElementById('process-submit-btn');
    
    // Reset all action cards
    document.querySelectorAll('.action-card').forEach(card => {
        card.classList.remove('border-primary', 'bg-light');
    });
    
    // Highlight selected action card
    event.currentTarget.classList.add('border-primary', 'bg-light');
    
    // Set action type
    actionType.value = action;
    
    // Show/hide reason field based on action
    if (action === 'reject' || action === 'draft') {
        reasonField.style.display = 'block';
        document.getElementById('process-reason').required = true;
    } else {
        reasonField.style.display = 'none';
        document.getElementById('process-reason').required = false;
    }
    
    // Update submit button text
    switch(action) {
        case 'approve':
            submitBtn.innerHTML = '<i class="fas fa-check me-2"></i>Approve Loan';
            submitBtn.className = 'btn btn-success';
            break;
        case 'reject':
            submitBtn.innerHTML = '<i class="fas fa-times me-2"></i>Reject Loan';
            submitBtn.className = 'btn btn-danger';
            break;
        case 'draft':
            submitBtn.innerHTML = '<i class="fas fa-archive me-2"></i>Save as Draft';
            submitBtn.className = 'btn btn-warning';
            break;
    }
    
    // Show action form
    actionForm.style.display = 'block';
}

function cancelProcessAction() {
    document.getElementById('process-action-form').style.display = 'none';
    document.getElementById('loan-process-form').reset();
    
    // Reset action cards
    document.querySelectorAll('.action-card').forEach(card => {
        card.classList.remove('border-primary', 'bg-light');
    });
}

// Handle process form submission
document.getElementById('loan-process-form')?.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const action = formData.get('action');
    const loanId = formData.get('loan_id');
    const reason = formData.get('reason');
    
    // Show loading state
    const submitBtn = document.getElementById('process-submit-btn');
    if (submitBtn) {
        const spinner = submitBtn.querySelector('.spinner-border');
        if (spinner) {
            spinner.style.display = 'inline-block';
        }
        submitBtn.disabled = true;
    }
    
    // Use the existing updateLoanOffer method
    let url = `/loan-offers/${loanId}`;
    
    // Prepare data based on action
    let postData = {
        _token: '{{ csrf_token() }}',
        _method: 'PUT'  // Laravel method spoofing for PUT requests
    };
    
    switch(action) {
        case 'approve':
            postData.approval = 'APPROVED';
            postData.status = 'APPROVED';
            break;
        case 'reject':
            postData.approval = 'REJECTED';
            postData.status = 'REJECTED';
            postData.reason = reason;
            break;
        case 'draft':
            postData.status = 'DRAFT';
            postData.reason = reason;
            break;
    }
    
    // Log for debugging
    console.log('Processing loan action:', action);
    console.log('Request URL:', url);
    console.log('Request data:', postData);
    
    // Make AJAX request
    $.ajax({
        url: url,
        method: 'POST',  // Using POST with _method field for Laravel
        data: postData,
        success: function(response) {
            console.log('Success response:', response);
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: `Loan has been ${action}ed successfully.`,
                confirmButtonColor: '#17479E'
            }).then(() => {
                $('#loanDetailsModal').modal('hide');
                location.reload();
            });
        },
        error: function(xhr, status, error) {
            console.error('Error response:', xhr.responseJSON);
            console.error('Status:', status);
            console.error('Error:', error);
            
            let errorMessage = 'Failed to process the loan.';
            if (xhr.responseJSON?.message) {
                errorMessage = xhr.responseJSON.message;
            } else if (xhr.responseJSON?.error) {
                errorMessage = xhr.responseJSON.error;
            } else if (xhr.responseText) {
                errorMessage = `Server error: ${xhr.status}`;
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: errorMessage,
                confirmButtonColor: '#17479E'
            });
        },
        complete: function() {
            if (submitBtn) {
                const spinner = submitBtn.querySelector('.spinner-border');
                if (spinner) {
                    spinner.style.display = 'none';
                }
                submitBtn.disabled = false;
            }
        }
    });
});

// Approve loan
function approveLoan(loanId) {
    Swal.fire({
        title: 'Approve Loan Application',
        text: 'Are you sure you want to approve this loan application?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, Approve',
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/loan-offers/${loanId}/approve`,
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    Swal.fire('Approved!', 'The loan has been approved.', 'success')
                        .then(() => location.reload());
                },
                error: function(xhr) {
                    Swal.fire('Error!', 'Failed to approve the loan.', 'error');
                }
            });
        }
    });
}

// Reject loan
function rejectLoan(loanId) {
    Swal.fire({
        title: 'Reject Loan Application',
        input: 'textarea',
        inputLabel: 'Rejection Reason',
        inputPlaceholder: 'Enter the reason for rejection...',
        inputAttributes: {
            'aria-label': 'Rejection reason'
        },
        showCancelButton: true,
        confirmButtonText: 'Reject',
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        inputValidator: (value) => {
            if (!value) {
                return 'You need to provide a reason for rejection';
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            // Process rejection
            $.ajax({
                url: `/loan-offers/${loanId}/reject`,
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    reason: result.value
                },
                success: function(response) {
                    Swal.fire('Rejected!', 'The loan has been rejected.', 'success')
                        .then(() => location.reload());
                },
                error: function(xhr) {
                    Swal.fire('Error', 'Failed to reject the loan.', 'error');
                }
            });
        }
    });
}

// Bulk actions
function bulkApprove() {
    const selected = Array.from(document.querySelectorAll('.loan-checkbox:checked')).map(cb => cb.value);
    processBulkAction('approve', selected);
}

function bulkDisburse() {
    const selected = Array.from(document.querySelectorAll('.loan-checkbox:checked')).map(cb => cb.value);
    processBulkAction('disburse', selected);
}

function bulkReject() {
    const selected = Array.from(document.querySelectorAll('.loan-checkbox:checked')).map(cb => cb.value);
    processBulkAction('reject', selected);
}

function processBulkAction(action, ids) {
    if (ids.length === 0) return;
    
    Swal.fire({
        title: `Confirm Bulk ${action.charAt(0).toUpperCase() + action.slice(1)}`,
        text: `Are you sure you want to ${action} ${ids.length} loan(s)?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: `Yes, ${action}`,
        confirmButtonColor: '#667eea'
    }).then((result) => {
        if (result.isConfirmed) {
            // Process bulk action
            $.ajax({
                url: '/loan-offers/bulk-action',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    action: action,
                    ids: ids
                },
                success: function(response) {
                    Swal.fire('Success!', response.message, 'success')
                        .then(() => location.reload());
                },
                error: function(xhr) {
                    Swal.fire('Error', 'Failed to process bulk action.', 'error');
                }
            });
        }
    });
}

// Toggle between table and card view
function toggleTableView() {
    // Implementation for switching between table and card view
    document.querySelector('.table-responsive').classList.toggle('card-view');
}
</script>
@endpush