
@extends('layouts.app')

@section('title', 'View Enquiry')

@section('content')
<nav class="page-breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{ route('enquiries.index') }}">Enquiries</a></li>
        <li class="breadcrumb-item active" aria-current="page">View Enquiry</li>

    </ol>

</nav>

<div class="row">
    <!-- Enquiry Details Column -->
    <div class="col-md-6 grid-margin stretch-card">
        <div class="card shadow-sm border-light">
            <div class="card-header">
                <div class="d-flex align-items-center">
                    <div>
                        <h6 class="mb-0">View Enquiry Details</h6>
                    </div>
                    <div class="dropdown ms-auto">
                        <a class="dropdown-toggle dropdown-toggle-nocaret" href="#" data-bs-toggle="dropdown">
                            <i class='bx bx-dots-horizontal-rounded font-22 text-option'></i>
                        </a>
                        <ul class="dropdown-menu">
                            <!-- View Action -->

                            <li><a class="dropdown-item" href="{{ route('enquiries.index') }}"><i class="mdi mdi-eye me-2"></i>Back to List</a></li>
                            <li><hr class="dropdown-divider"></li>



                            <!-- Assign Action (triggers modal) -->
                            <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#assignUserModal-{{ $enquiry->id }}"><i class="mdi mdi-account-arrow-right me-2"></i>Assign</a></li>
                            <li><hr class="dropdown-divider"></li>


<!-- Edit Action -->
<li><a class="dropdown-item" href="{{ route('enquiries.edit', $enquiry->id) }}"><i class="mdi mdi-pencil me-2"></i>Edit</a></li>
<li><hr class="dropdown-divider"></li>


                            <!-- Delete Action -->
                            <li class="dropdown-item">
                                <form action="{{ route('enquiries.destroy', $enquiry->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                </form>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card-body">

                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Date Received:</span>
                        <span class="text-muted">{{ $enquiry->date_received }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Force Number:</span>
                        <span class="text-muted">{{ $enquiry->force_no }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Account Number:</span>
                        <span class="text-muted">{{ $enquiry->account_number }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Name of the Bank:</span>
                        <span class="text-muted">{{ $enquiry->bank_name }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Check Number:</span>
                        <span class="text-muted">{{ $enquiry->check_number }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Full Name:</span>
                        <span class="text-muted">{{ $enquiry->full_name }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Enquiry Type:</span>
                        <span class="text-muted">{{ ucfirst(str_replace('_', ' ', $enquiry->type)) }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Region:</span>
                        <span class="text-muted">{{ $enquiry->region->name ?? 'No Region' }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">District:</span>
                        <span class="text-muted">{{ $enquiry->district->name ?? 'No District' }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span class="fw-bold">Phone:</span>
                        <span class="text-muted">{{ $enquiry->phone }}</span>
                    </li>

                </ul>


                <!-- Action Buttons -->

            </div>
        </div>
    </div>

    <!-- File Display Column -->
    <div class="col-md-6 grid-margin stretch-card">
        <div class="card shadow-sm border-light">
        <h5 class="card-header  text-primary mb-4">Enquiry File</h5>
            <div class="card-body">
                @if ($enquiry->file_path)
                    <object data="{{ asset($enquiry->file_path) }}" type="application/pdf" width="100%" height="600px" class="border rounded">
                        <p class="text-muted">Your browser does not support PDFs.
                            <a href="{{ asset($enquiry->file_path) }}" class="text-decoration-underline">Download the PDF</a>.
                        </p>
                    </object>
                @else
                    <p class="text-muted">No file uploaded.</p>
                @endif
            </div>
        </div>
    </div>
</div>
@include('modals.assign_enquries')
@endsection
