@extends('layouts.app')

@section('content')
    <h1>File Series</h1>
    <a href="{{ route('file_series.create') }}" class="btn btn-primary">Create New File Series</a>
    <table class="table table-striped mt-3">
        <thead>
            <tr>
                <th>Name</th>
                <th>Code</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($fileSeries as $series)
                <tr>
                    <td>{{ $series->name }}</td>
                    <td>{{ $series->code }}</td>
                    <td>
                        <a href="{{ route('file_series.edit', $series) }}" class="btn btn-sm btn-secondary">Edit</a>
                        <form action="{{ route('file_series.destroy', $series) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
