@extends('layouts.app')

@section('content')
    <h1>Keywords</h1>
    <a href="{{ route('keywords.create') }}" class="btn btn-primary">Add New Keyword</a>
    <table class="table table-striped mt-3">
        <thead>
            <tr>
                <th>Name</th>
                <th>Code</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($keywords as $keyword)
                <tr>
                    <td>{{ $keyword->name }}</td>
                    <td>{{ $keyword->code }}</td>
                    <td>
                        <a href="{{ route('keywords.edit', $keyword) }}" class="btn btn-sm btn-secondary">Edit</a>
                        <form action="{{ route('keywords.destroy', $keyword) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
