

@extends('layouts.app')

@section('content')

<style>

    /* Custom styling for tables */
    #example2 th, #example2 td {
        border: 1px solid #dee2e6; /* Light border for table cells */
        padding: 12px; /* Added padding for better readability */
        text-align: left; /* Align text to the left */
    }

</style>

<div class="container-fluid">
    <div class="page-breadcrumb d-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3">LOAN APPLICATIONS</div>
        <div class="ps-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 p-0">
                    {{-- <li class="breadcrumb-item"><a href="{{ route('enquiries.index') }}"><i class="bx bx-home-alt"></i></a></li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ $type ? ucfirst(str_replace('_', ' ', $type)) . ' Enquiries' : 'All Enquiries' }}
                    </li> --}}
                </ol>
            </nav>
        </div>
    </div>
    <!--cards  starts here------------------------------------------>
    {{-- <h1>Loan Applications</h1> --}}

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="example2" class="table table-striped table-bordered" style="width:100%">
                    <thead>
            <tr>
                <th>ID</th>
                <th>Full Name</th>
                <th>Loan Amount</th>
                <th>Duration</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($enquiries as $enquiry)
            @if($enquiry->loanApplication)  {{-- Ensure there is a loan application --}}
            <tr>
                <td>{{ $enquiry->loanApplication->id }}</td>
                <td>{{ $enquiry->full_name }}</td>
                <td>{{ number_format($enquiry->loanApplication->loan_amount) }}</td>
                <td>{{ $enquiry->loanApplication->loan_duration }} months</td>
                <td>
    @if ($enquiry->loanApplication->status == 'rejected')
        <div class="badge rounded-pill text-danger bg-light-danger p-2 text-uppercase px-3">
            <i class='bx bxs-x-circle align-middle me-1'></i>Rejected
        </div>
    @elseif ($enquiry->loanApplication->status == 'approved')
        <div class="badge rounded-pill text-success bg-light-success p-2 text-uppercase px-3">
            <i class='bx bxs-check-circle align-middle me-1'></i>Approved
        </div>
    @elseif ($enquiry->loanApplication->status == 'pending')
        <div class="badge rounded-pill text-warning bg-light-warning p-2 text-uppercase px-3">
            <i class='bx bxs-hourglass align-middle me-1'></i>Pending
        </div>
    @elseif ($enquiry->loanApplication->status == 'processed')
        <div class="badge rounded-pill text-info bg-light-info p-2 text-uppercase px-3">
            <i class='bx bxs-circle align-middle me-1'></i>Processed
        </div>
    @else
        <div class="badge rounded-pill text-secondary bg-light-secondary p-2 text-uppercase px-3">
            <i class='bx bxs-info-circle align-middle me-1'></i>Unknown Status
        </div>
    @endif
</td>

                <td>
                    <!-- Action buttons that trigger modals -->
                    {{-- <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#processLoanModal-{{ $enquiry->loanApplication->id }}">Process</button>
                    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#approveLoanModal-{{ $enquiry->id }}">Approve</button>
                    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectLoanModal-{{ $enquiry->id }}">Reject</button> --}}
                    <div class="dropdown ms-auto">
                        <a class="dropdown-toggle dropdown-toggle-nocaret" href="#" data-bs-toggle="dropdown">
                            <i class='bx bx-dots-horizontal-rounded font-22 text-option'></i>
                        </a>
                        <ul class="dropdown-menu">
                        <li>
                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#viewLoanDetailsModal-{{ $enquiry->loanApplication->id }}"><i class="fa fa-eye me-2"></i> View</a>
                            </li>
                            <hr class="dropdown-divider">

                            <li>
                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#processLoanModal-{{ $enquiry->loanApplication->id }}"> <i class="fa fa-cogs me-2"></i> Process Loan</a>
                            </li>
                            <hr class="dropdown-divider">

                            {{-- <li>
                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#approveLoanModal-{{ $enquiry->id }}">Approve Loan</a>
                            </li> --}}
                            <li>
                                <!-- Trigger SweetAlert for loan approval verification -->
                                <a href="#" class="dropdown-item" onclick="triggerLoanApprovalSend({{$enquiry->loanApplication->id }})">
                                    <i class="fa fa-check-circle me-2"></i>Approve Loan
                                </a>
                                {{-- <a href="#" class="dropdown-item" onclick="triggerLoanApprovalSend({{ $loanApplication->id }})"> --}}
                            </li>

                            <hr class="dropdown-divider">
                            <li>
                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#rejectLoanModal-{{ $enquiry->id }}"><i class="fa fa-times-circle me-2"></i> Reject Loan</a>
                            </li>
                            <hr class="dropdown-divider">

                        </ul>
                    </div>

                </td>
            </tr>
            @endif
            @endforeach
        </tbody>
    </table>
</div></div></div></div>

<!-- Include the modals for each loan application -->
@foreach ($enquiries as $enquiry)
    @if($enquiry->loanApplication)
        @include('modals.approve_loan', ['enquiry' => $enquiry])
        @include('modals.process_loan', ['enquiry' => $enquiry])
        @include('modals.reject_loan', ['enquiry' => $enquiry])
        @include('modals.view_loan', ['enquiry' => $enquiry])
    @endif
@endforeach

@endsection




