{{--
<div class="modal fade" id="approveLoanModal-{{ $enquiry->id }}" tabindex="-1" aria-labelledby="approveLoanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Approve Loan Application</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('loans.approve', ['loanApplication' => $enquiry->loanApplication->id]) }}" method="POST" onsubmit="showSpinner(this);">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <!-- Detail Card Column -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <strong><i class="bi bi-check-circle-fill"></i> Loan Details</strong>
                                </div>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><strong>Date Received:</strong> {{ $enquiry->getDateReceivedAttribute($enquiry->date_received) }}</li>
                                    <li class="list-group-item"><strong>Name:</strong> {{ $enquiry->full_name }}</li>
                                    <li class="list-group-item"><strong>Loan Amount:</strong> {{ number_format($enquiry->loanApplication->loan_amount) }}</li>
                                    <li class="list-group-item"><strong>Duration:</strong> {{ $enquiry->loanApplication->loan_duration }} months</li>
                                    <li class="list-group-item"><strong>Interest:</strong> {{ $enquiry->loanApplication->interest_rate }}%</li>
                                </ul>
                            </div>
                        </div>
                        <!-- Attachment Card Column -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <strong><i class="bi bi-file-earmark-text-fill"></i> Attachments</strong>
                                </div>
                                <div class="card-body">
                                    @if ($enquiry->file_path)
                                    <object data="{{ asset($enquiry->file_path) }}" type="application/pdf" width="100%" height="500px" class="border rounded">
                                        <p class="text-muted">Your browser does not support PDFs.
                                            <a href="{{ asset($enquiry->file_path) }}" class="text-decoration-underline">Download the PDF</a>.
                                        </p>
                                    </object>
                                    @else
                                        <p class="text-muted">No file uploaded.</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success btn-sm"id="submit-button-{{ $enquiry->id }}">Approve Loan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
function showSpinner(form) {
        // Disable the submit button
        var submitButton = form.querySelector('button[type="submit"]');
        submitButton.disabled = true;
        submitButton.innerHTML = 'Processing... <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
    }

    document.addEventListener('DOMContentLoaded', function() {
        @if (session('success'))
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: '{{ session('success') }}',
                confirmButtonText: 'OK'
            });
        @endif
    });
</script>
 --}}
 <script>
    function triggerLoanApprovalSend(loanApplicationId) {
        Swal.fire({
            title: 'Confirm Loan Approval',
            text: "Are you sure you want to approve this loan?",
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, approve it!'
        }).then((result) => {
            if (result.isConfirmed) {
                sendLoanApprovalOtp(loanApplicationId);
            }
        });
    }

    // function sendLoanApprovalOtp(loanApplicationId) {
    //     const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    //     fetch(`/loans/${loanApplicationId}/send-otp-approve-loan`, {
    //         method: 'POST',
    //         headers: {
    //             'X-CSRF-TOKEN': csrfToken,
    //             'Content-Type': 'application/json'
    //         }
    //     })
    //     .then(response => response.json())
    //     .then(data => {
    //         if (data.success) {
    //             promptForLoanApprovalOTP(loanApplicationId);
    //         } else {
    //             Swal.fire('Failed', 'Failed to send OTP. Please try again.', 'error');
    //         }
    //     })
    //     .catch(error => {
    //         console.error('Error sending OTP:', error);
    //         Swal.fire('Error', 'An error occurred while sending OTP.', 'error');
    //     });
    // }
    function sendLoanApprovalOtp(loanApplicationId) {
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    fetch(`/loans/${loanApplicationId}/send-otp-approve-loan`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': csrfToken,
            'Content-Type': 'application/json'
        }
    })
    .then(handleErrors)
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            promptForLoanApprovalOTP(loanApplicationId);
        } else {
            Swal.fire('Failed', data.message || 'Failed to send OTP. Please try again.', 'error');
        }
    })
    .catch(error => {
        console.error('Error sending OTP:', error);
        Swal.fire('Error', 'An error occurred while sending OTP.', 'error');
    });
}

function handleErrors(response) {
    if (!response.ok) {
        throw Error(response.statusText);
    }
    return response;
}

    function promptForLoanApprovalOTP(loanApplicationId) {
        Swal.fire({
            title: 'Enter your OTP',
            input: 'text',
            inputAttributes: {
                autocapitalize: 'off',
                autocorrect: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Verify OTP',
            showLoaderOnConfirm: true,
            preConfirm: (otp) => {
                return verifyLoanApprovalOTP(loanApplicationId, otp);
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((result) => {
            if (result.isConfirmed && result.value.success) {
                Swal.fire(
                    'Verified!',
                    'The loan has been successfully approved.',
                    'success'
                );
            } else if (result.isDismissed || !result.value.success) {
                Swal.fire(
                    'Failed',
                    'OTP verification failed. Please try again.',
                    'error'
                );
            }
        });
    }

    function verifyLoanApprovalOTP(loanApplicationId, otp) {
        return fetch(`/loans/${loanApplicationId}/verify-otp-approve-loan`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({ otp: otp })
        }).then(response => {
            if (!response.ok) {
                throw new Error('Server responded with a status: ' + response.status);
            }
            return response.json();
        }).catch(error => {
            console.error('Error verifying OTP:', error);
            throw error;
        });
    }
    </script>
