@extends('layouts.app')

@section('content')
<div class="container">


    <div class="row">
        <div class="col-md-12">
            <div class="card shadow-sm">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
    <h5 class="mb-0 text-white">Edit User</h5> <!-- Use a heading for better semantics -->
    <div>
        <a href="{{ route('users.index') }}" class="btn btn-info btn-sm">
            <i class="fas fa-arrow-left"></i> Back to Users
        </a>
    </div>
</div>
                <div class="card-body">
                    <form id="myForm" action="{{ route('users.update', $user->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="name">Name:</label>
                                <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $user->name) }}" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="email">Email:</label>
                                <input type="email" class="form-control" id="email" name="email" value="{{ old('email', $user->email) }}" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="phone">Phone Number:</label>
                                <input type="text" class="form-control" id="phone" name="phone_number" value="{{ old('phone_number', $user->phone_number) }}">
                                <small id="phoneHelp" class="form-text"></small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="password">Password:</label>
                                <input type="password" class="form-control" id="password" name="password">
                                <small id="passwordStrength" class="form-text"></small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="confirm_password">Confirm Password:</label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password">
                                <small id="passwordHelp" class="form-text text-danger"></small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="rank">Rank:</label>
                                <input type="text" class="form-control" id="rank" name="rank" value="{{ old('rank', $user->rank) }}">
                            </div>
                        </div>

                        <!-- Administrative Access Policy Section -->
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="status">Status:</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="active" {{ old('status', $user->status) == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ old('status', $user->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="role">Role:</label>
                                <select class="form-control" id="role" name="role" required>
                                    @foreach(\Spatie\Permission\Models\Role::all() as $role)
                                        <option value="{{ $role->name }}" {{ $user->roles->contains('name', $role->name) ? 'selected' : '' }}>
                                            {{ $role->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="designation">Designation:</label>
                                <input type="text" class="form-control" id="designation" name="designation" value="{{ old('designation', $user->designation) }}" required>
                            </div>
                        </div>

                        <!-- Location and Department Section -->
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="region_id">Region:</label>
                                <select class="form-control select2" id="region_id" name="region_id" required onchange="updateDistricts()">
                                    <option value="">Select Region</option>
                                    @foreach($regions as $region)
                                        <option value="{{ $region->id }}" {{ old('region_id', $user->region_id) == $region->id ? 'selected' : '' }}>
                                            {{ $region->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="district_id">District:</label>
                                <select class="form-control select2" id="district_id" name="district_id" required>
                                    <option value="">Select District</option>
                                    @foreach($districts as $district)
                                        <option value="{{ $district->id }}" {{ old('district_id', $user->district_id) == $district->id ? 'selected' : '' }}>
                                            {{ $district->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="department_id">Department:</label>
                                <select class="form-control" id="department_id" name="department_id" required>
                                    <option value="">Select Department</option>
                                    @foreach($departments as $department)
                                        <option value="{{ $department->id }}" {{ old('department_id', $user->department_id) == $department->id ? 'selected' : '' }}>
                                            {{ $department->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="command_id">Command:</label>
                                <select class="form-control" id="command_id" name="command_id" required>
                                    <option value="">Select Command</option>
                                    @foreach($commands as $command)
                                        <option value="{{ $command->id }}" {{ old('command_id', $user->command_id) == $command->id ? 'selected' : '' }}>
                                            {{ $command->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="branch_id">Branch:</label>
                                <select class="form-control" id="branch_id" name="branch_id" required>
                                    <option value="">Select Branch</option>
                                    @foreach($branches as $branch)
                                        <option value="{{ $branch->id }}" {{ old('branch_id', $user->branch_id) == $branch->id ? 'selected' : '' }}>
                                            {{ $branch->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary btn-block" id="submitButton" disabled>
                            <span id="buttonText"><i class="fas fa-edit me-2"></i>Update User</span>
                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="loadingSpinner"></span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function updateDistricts() {
        const regionId = document.getElementById('region_id').value;
        const districtSelect = document.getElementById('district_id');
        districtSelect.innerHTML = '<option value="">Select District</option>'; // Clear existing options

        if (!regionId) return; // If no region is selected, stop here

        // Populate districts based on selected region
        @json($regions).forEach(region => {
            if (region.id == regionId) {
                region.districts.forEach(district => {
                    let option = new Option(district.name, district.id);
                    districtSelect.add(option);
                });
            }
        });
    }

    function validateForm() {
        const inputs = document.querySelectorAll('#myForm input, #myForm select');
        const submitButton = document.getElementById('submitButton');
        let allFilled = true;

        inputs.forEach(input => {
            if (!input.value) {
                allFilled = false;
            }
        });

        submitButton.disabled = !allFilled; // Enable/disable button based on form completion
    }

    $(document).ready(function() {
        $('#region_id').select2({
            theme: 'bootstrap',
            placeholder: "Select a Region",
            allowClear: true
        });

        $('#district_id').select2({
            theme: 'bootstrap',
            placeholder: "Select a District",
            allowClear: true
        });

        $('#phone').on('focus', function() {
            if ($(this).val() === '') {
                $(this).val('255');
            }
        });

        $('#phone').on('input', function() {
            const phoneValue = $(this).val();
            const phoneHelp = $('#phoneHelp');
            phoneHelp.removeClass('text-danger text-success');

            if (!phoneValue.startsWith('255') || phoneValue.length < 12) {
                phoneHelp.text('Phone number must start with "255" and be at least 12 digits long.');
                phoneHelp.addClass('text-danger');
                $('#submitButton').prop('disabled', true);
            } else {
                phoneHelp.text('Phone number is valid.');
                phoneHelp.addClass('text-success');
                $('#submitButton').prop('disabled', false);
            }
        });

        $('#password').on('input', function() {
            const passwordValue = $(this).val();
            const passwordStrength = $('#passwordStrength');
            passwordStrength.removeClass('text-danger text-success');

            // Check password strength
            if (passwordValue.length < 8) {
                passwordStrength.text('Password must be at least 8 characters long.');
                passwordStrength.addClass('text-danger');
            } else if (!/[A-Z]/.test(passwordValue) || !/[0-9]/.test(passwordValue)) {
                passwordStrength.text('Password must contain at least one uppercase letter and one number.');
                passwordStrength.addClass('text-danger');
            } else {
                passwordStrength.text('Password is strong.');
                passwordStrength.addClass('text-success');
            }
        });

        $('#confirm_password').on('input', function() {
            const confirmPasswordValue = $(this).val();
            const passwordValue = $('#password').val();
            const passwordHelp = $('#passwordHelp');

            if (confirmPasswordValue !== passwordValue) {
                passwordHelp.text('Passwords do not match.');
            } else {
                passwordHelp.text('');
            }
        });

        // Event listener to validate form on input change
        $('input, select').on('input change', validateForm);
    });
</script>

@endsection
