<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Carbon\Carbon;

class LoginStatsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'employees:login-stats {--format=table : Output format (table|json)}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Display employee login statistics';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $now = Carbon::now();
        $format = $this->option('format');

        // Gather statistics
        $stats = [
            'Total Employees' => User::employees()->count(),
            'Online Now' => User::employees()->online()->count(),
            'Recently Online' => User::employees()->recentlyOnline()->count(),
            'Logged in Today' => User::employees()->loggedInToday()->count(),
            'Logged in Yesterday' => User::employees()->whereDate('last_login', $now->copy()->subDay())->count(),
            'Logged in This Week' => User::employees()->loggedInThisWeek()->count(),
            'Logged in This Month' => User::employees()->loggedInThisMonth()->count(),
            'Logged in This Year' => User::employees()->whereYear('last_login', $now->year)->count(),
            'Password Changed This Month' => User::employees()->passwordChangedRecently(30)->count(),
            'Never Logged In' => User::employees()->whereNull('last_login')->count(),
            'Suspended Accounts' => User::employees()->where('status', 'suspended')->count(),
        ];

        if ($format === 'json') {
            $this->line(json_encode($stats, JSON_PRETTY_PRINT));
        } else {
            $this->info('Employee Login Statistics');
            $this->info('Generated at: ' . $now->format('Y-m-d H:i:s'));
            $this->newLine();

            $tableData = [];
            foreach ($stats as $label => $count) {
                $tableData[] = [$label, $count];
            }

            $this->table(['Metric', 'Count'], $tableData);
        }

        return 0;
    }
}